package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Complaint;
import ru.yandex.webmaster3.core.semantic.review_business.util.DateHelper;

import java.util.Date;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.ComplaintAttributes.*;

/**
 * TODO
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class ComplaintOverJson extends Complaint {

    private final JSONObject json;

    /**
     * This implementation breaks the contract for hashCode (because hashCode is counted
     * on top of all get methods of Object and JSONObject is mutable and cannot be controlled from
     * this implementation)
     * Visibility will be changed to package private (in case of necessity
     * of usage in constructing of high-level objects) or removed completely
     */
    @Deprecated
    public ComplaintOverJson(final JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create Complaint over null JSON");
        this.json = json;
    }
    public ComplaintOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create Complaint over empty JSON string");
        this.json = new JSONObject(json);
    }

    @Override
    public String getId() {
        return json.optString(ID, null);
    }

    @Override
    public Long getBizId() {
        return json.optLong(BIZ_ID);
    }

    @Override
    public String getReviewId() {
        return json.optString(REVIEW_ID, null);
    }

    @Override
    public Reason getReason() {
        final String reasonAsStr = json.optString(REASON_ID, null);
        return reasonAsStr == null ? null :
                Reason.valueOf(reasonAsStr);
    }

    @Override
    public String getText() {
        return json.optString(TEXT);
    }

    @Override
    public CheckStatus getCheckStatus() {
        final String checkStatusAsStr = json.optString(CHECK_STATUS_ID, null);
        return checkStatusAsStr == null ? null :
                CheckStatus.valueOf(checkStatusAsStr);
    }

    @Override
    public String getCheckMessage() {
        return json.optString(CHECK_MESSAGE, null);
    }

    @Override
    public Date getCreationDate() {
        return DateHelper.read(json.optString(CREATE_DATE, null));
    }

    @Override
    public Long getHandlerUid() {
        return json.optLong(HANDLER_UID);
    }

    @Override
    public Date getHandledTime() {
        return DateHelper.read(json.optString(HANDLED_TIME, null));
    }
}

