package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Feature;

import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.FeatureAttributes.NAME;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.FeatureAttributes.VALUE;

/**
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class FeatureJsonConversions {
    private static final Logger log = LoggerFactory.getLogger(FeatureJsonConversions.class);

    /**
     * Use {@link #FEATURE_TO_JSON_STRING} instead
     */
    @Deprecated
    public static final Function<Feature, JSONObject> FEATURE_TO_JSON =
            new Function<Feature, JSONObject>() {
                @Override
                public JSONObject apply(final Feature feature) {
                    return safeToJson(feature);
                }
            };

    /**
     * Use {@link #JSON_STRING_TO_FEATURE} instead
     */
    @Deprecated
    public static final Function<JSONObject, Feature> JSON_TO_FEATURE =
            new Function<JSONObject, Feature>() {
                @Override
                public Feature apply(final JSONObject json) {
                    return fromJson(json);
                }
            };
    public static final Function<Feature, String> FEATURE_TO_JSON_STRING =
            new Function<Feature, String>() {
                @Override
                public String apply(final Feature feature) {
                    return safeToJsonString(feature);
                }
            };

    public static final Function<String, Feature> JSON_STRING_TO_FEATURE =
            new Function<String, Feature>() {
                @Override
                public Feature apply(final String json) {
                    return safeFromJson(json);
                }
            };

    private FeatureJsonConversions() {
    }

    /**
     * Use {@link #fromJson(String)} (throws {@link JSONException}) and {@link #safeFromJson(String)} instead
     */
    @Deprecated
    public static Feature fromJson(final JSONObject json) {
        return new FeatureOverJson(json);
    }
    public static Feature fromJson(final String json) throws JSONException {
        return new FeatureOverJson(json);
    }
    public static Feature safeFromJson(final String json) {
        try {
            return fromJson(json);
        } catch (JSONException e) {
            log.error("Error while parsing Feature from json", e);
            return null;
        }
    }


    /**
     * Use {@link #toJsonString(Feature)} instead
     */
    @Deprecated
    public static JSONObject toJson(final Feature feature) throws JSONException {
        Preconditions.checkNotNull(feature, "Unable to convert null Feature to JSON");
        return new JSONObject().
                putOpt(NAME, feature.getName()).
                putOpt(VALUE, feature.getValue());
    }
    public static String toJsonString(final Feature feature) throws JSONException {
        JSONObject obj;
        obj = toJson(feature);

        return obj.toString();
    }

    /**
     * Use {@link #safeToJsonString(Feature)} instead
     */
    @Deprecated
    public static JSONObject safeToJson(final Feature feature) {
        try {
            return toJson(feature);
        } catch (JSONException e) {
            log.error("Error while convert Feature to JSON", e);
            return null;
        }
    }
    public static String safeToJsonString(final Feature feature) {
        try {
            return toJsonString(feature);
        } catch (JSONException e) {
            log.error("Error while convert Feature to JSON", e);
            return null;
        }
    }
}
