package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Feature;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.FeatureAttributes.*;
/**
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class FeatureOverJson extends Feature {
    private final JSONObject json;

    /**
     * This implementation breaks the contract for hashCode (because hashCode is counted
     * on top of all get methods of Object and JSONObject is mutable and cannot be controlled from
     * this implementation)
     * Visibility will be changed to package private (in case of necessity
     * of usage in constructing of high-level objects) or removed completely
     */
    @Deprecated
    public FeatureOverJson(final JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create Feature over null JSON");
        this.json = json;
    }

    public FeatureOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create Feature over empty JSON string");
        this.json = new JSONObject(json);
    }

    @Override
    public String getName() {
        return json.optString(NAME, null);
    }

    @Override
    public String getValue() {
        return json.optString(VALUE, null);
    }
}
