package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Geo;

import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.HCardAttributes.LATITUDE;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.HCardAttributes.LONGITUDE;

public class GeoJsonConversions {


    private static final Logger log = LoggerFactory.getLogger(GeoJsonConversions.class);

    private GeoJsonConversions() {
    }

    public static Geo fromJson(final String json) throws JSONException {
        try {
            return new GeoOverJson(json);
        } catch (JSONException e) {
            log.error("Problems while converting json to geo.");
            throw new JSONException(e);
        }
    }

    public static JSONObject toJson(final Geo geo) {
        Preconditions.checkNotNull(geo, "Unable to convert null Geo to JSON");
        try {
            return new JSONObject().
                    putOpt(LATITUDE, geo.getLatitude()).
                    putOpt(LONGITUDE, geo.getLongitude());
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(final Geo geo) {
        return toJson(geo).toString();
    }
}
