package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Geo;
import ru.yandex.webmaster3.core.semantic.review_business.util.JsonAccessUtils;

import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.BizReviewAttributes.LATITUDE;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.BizReviewAttributes.LONGITUDE;

public class GeoOverJson extends Geo {

    private static final Logger log = LoggerFactory.getLogger(GeoOverJson.class);

    private final JSONObject json;

    public GeoOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(Strings.emptyToNull(json), "Unable to create Geo over empty JSON string");
        try {
            this.json = new JSONObject(json);
        } catch (JSONException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public Float getLatitude() {
        return JsonAccessUtils.optFloat(json, LATITUDE);
    }

    @Override
    public Float getLongitude() {
        return JsonAccessUtils.optFloat(json, LONGITUDE);
    }
}

