package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Moderation2;
import ru.yandex.webmaster3.core.semantic.review_business.util.DateHelper;

import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.Moderation2Attributes.*;

/**
 * Helps to convert {@see Moderation2} to {@see JSONObject} and vise-versa
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public final class Moderation2JsonConversions {

    private static final Logger log = LoggerFactory.getLogger(Moderation2JsonConversions.class);
    /**
     * Use {@link #JSON_STRING_TO_MODERATION} instead
     */
    @Deprecated
    public static final Function<JSONObject, Moderation2> JSON_TO_MODERATION =
            new Function<JSONObject, Moderation2>() {
                @Override
                public Moderation2 apply(final JSONObject arg) {
                    return fromJson(arg);
                }
            };

    /**
     * Use {@link #MODERATION_TO_JSON_STRING} instead
     */
    @Deprecated
    public static final Function<Moderation2, JSONObject> MODERATION_TO_JSON =
            new Function<Moderation2, JSONObject>() {
                @Override
                public JSONObject apply(final Moderation2 arg) {
                    try {
                        return toJson(arg);
                    } catch (JSONException e) {
                       throw new RuntimeException(e);
                    }
                }
            };
    public static final Function<String, Moderation2> JSON_STRING_TO_MODERATION =
            new Function<String, Moderation2>() {
                @Override
                public Moderation2 apply(final String arg) {
                    return safeFromJson(arg);
                }
            };

    public static final Function<Moderation2, String> MODERATION_TO_JSON_STRING =
            new Function<Moderation2, String>() {
                @Override
                public String apply(final Moderation2 arg) {
                    return safeToJsonString(arg);
                }
            };

    private Moderation2JsonConversions() {
    }

    /**
     * Use {@link #fromJson(String)} (throws {@link JSONException}) and {@link #safeFromJson(String)} instead
     */
    @Deprecated
    public static Moderation2 fromJson(final JSONObject json) {
        return new Moderation2OverJson(json);
    }

    public static Moderation2 fromJson(final String json) throws JSONException {
        return new Moderation2OverJson(json);
    }

    public static Moderation2 safeFromJson(final String json) {
        try {
            return fromJson(json);
        } catch (JSONException e) {
            log.error("Error while parsing Moderation2 from json", e);
            return null;
        }
    }

    /**
     * Use {@link #safeToJsonString(ru.yandex.webmaster3.core.semantic.review_business.biz.model.Moderation2)} instead
     */
    @Deprecated
    public static JSONObject toJson(final Moderation2 moderation) throws JSONException {
        Preconditions.checkNotNull(moderation, "Unable to write null Moderation2 to JSON");
        return new JSONObject().
                putOpt(STATUS, moderation.getStatus()).
                putOpt(REJECTION_REASON, moderation.getRejectionReason()).
                putOpt(CUSTOM_REJECTION_TEXT, moderation.getCustomRejectionText()).
                putOpt(HANDLER, moderation.getHandler()).
                putOpt(TIME, DateHelper.safeWrite(moderation.getTime())).
                putOpt(NOTE, moderation.getNote());
    }

    public static String toJsonString(final Moderation2 moderation2) throws JSONException {
        JSONObject obj;
        obj = toJson(moderation2);
        return obj.toString();
    }

    public static String safeToJsonString(final Moderation2 moderation2) {
        try {
            return toJsonString(moderation2);
        } catch (JSONException e) {
            log.error("Error while convert Moderation2 to JSON", e);
            return null;
        }
    }
}

