package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Tag;

import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.TagAttributes.*;

/**
 * @author: ishalaru
 * DATE: 14.10.2019
 */
public class TagJsonConversions {
    private static final Logger log = LoggerFactory.getLogger(TagJsonConversions.class);

    /**
     * Use {@link #JSON_STRING_TO_TAG} instead
     */
    @Deprecated
    public static Function<JSONObject, Tag> JSON_TO_TAG = new Function<JSONObject, Tag>() {
        @Override
        public Tag apply(final JSONObject json) {
            return fromJson(json);
        }
    };

    /**
     * Use {@link #TAG_TO_JSON_STRING} instead
     */
    @Deprecated
    public static Function<Tag, JSONObject> TAG_TO_JSON = new Function<Tag, JSONObject>() {
        @Override
        public JSONObject apply(final Tag tag) {
            return safeToJson(tag);
        }
    };

    public static Function<String, Tag> JSON_STRING_TO_TAG = new Function<String, Tag>() {
        @Override
        public Tag apply(final String json) {
            return safeFromJson(json);
        }
    };

    public static Function<Tag, String> TAG_TO_JSON_STRING = new Function<Tag, String>() {
        @Override
        public String apply(final Tag tag) {
            return safeToJsonString(tag);
        }
    };

    private TagJsonConversions() {
    }

    /**
     * Use {@link #fromJson(String)} (throws {@link }) and {@link #safeFromJson(String)} instead
     */
    @Deprecated
    public static Tag fromJson(final JSONObject json) {
        return new TagOverJson(json);
    }

    public static Tag fromJson(final String json) throws JSONException {
        return new TagOverJson(json);
    }

    public static Tag safeFromJson(final String json) {
        try {
            return fromJson(json);
        } catch (JSONException e) {
            log.error("Error while parsing Tag from json", e);
            return null;
        }
    }


    /**
     * Use {@link #toJsonString(Tag)} instead
     */
    @Deprecated
    public static JSONObject toJson(final Tag tag) throws JSONException {
        Preconditions.checkNotNull(tag, "Unable to convert null Tag to JSON");
        return new JSONObject().
                putOpt(NAME, tag.getName()).
                putOpt(VALUE, tag.getValue()).
                putOpt(TYPE, tag.getType() != null ?
                        tag.getType().toString() :
                        null).
                putOpt(CAPTION, tag.getCaption());
    }

    public static String toJsonString(final Tag tag) throws JSONException {
        JSONObject obj;
        obj = toJson(tag);
        return obj.toString();
    }

    /**
     * Use {@link #safeToJsonString(Tag)} instead
     */
    @Deprecated
    public static JSONObject safeToJson(final Tag tag) {
        try {
            return toJson(tag);
        } catch (JSONException e) {
            log.error("Error while converting Tag to JSON", e);
            return null;
        }
    }

    public static String safeToJsonString(final Tag tag) {
        try {
            return toJsonString(tag);
        } catch (JSONException e) {
            log.error("Error while convert Tag to JSON", e);
            return null;
        }
    }


}
