package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Tag;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.TagAttributes.*;

/**
 * @author: ishalaru
 * DATE: 14.10.2019
 */
public class TagOverJson extends Tag {
    private final JSONObject json;

    /**
     * This implementation breaks the contract for hashCode (because hashCode is counted
     * on top of all get methods of Object and JSONObject is mutable and cannot be controlled from
     * this implementation)
     * Visibility will be changed to package private (in case of necessity
     * of usage in constructing of high-level objects) or removed completely
     */
    @Deprecated
    public TagOverJson(final JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create Tag over null JSON");
        this.json = json;
    }
    public TagOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create Tag over empty JSON string");
            this.json = new JSONObject(json);
    }

    @Override
    public String getValue() {
        return json.optString(VALUE, null);
    }

    @Override
    public String getName() {
        return json.optString(NAME, null);
    }

    @Override
    public Type getType() {
        final String name = json.optString(TYPE, null);
        return name == null ? null : Type.valueOf(name);
    }

    @Override
    public String getCaption() {
        return json.optString(CAPTION, null);
    }
}
