package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.UgcBizReview;
import ru.yandex.webmaster3.core.semantic.review_business.model.impl.json.UserIdentityJsonConversions;

import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.UgcBizReviewAttributes.*;

/**
 * Helps to convert {@link UgcBizReview} to {@link JSONObject}
 * and vise versa.
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public final class UgcBizReviewJsonConversions {
    private static final Logger log = LoggerFactory.getLogger(UgcBizReviewJsonConversions.class);

    private UgcBizReviewJsonConversions() {
    }

    /**
     * Use {@link #fromJson(String)} (throws {@link JSONException}) and {@link #safeFromJson(String)} instead
     */
    @Deprecated
    public static UgcBizReview fromJson(final JSONObject json) {
        return new UgcBizReviewOverJson(json);
    }

    public static UgcBizReview fromJson(final String json) throws JSONException {
        return new UgcBizReviewOverJson(json);
    }

    public static UgcBizReview safeFromJson(final String json) {
        try {
            return fromJson(json);
        } catch (JSONException e) {
            log.error("Error while parsing UgcBizReview from json", e);
            return null;
        }
    }

    public static JSONObject toJson(final UgcBizReview r) throws JSONException {
        Preconditions.checkNotNull(r, "Unable to convert null UgcBizReview to JSON");
        return new JSONObject().
                putOpt("biz-review", BizReviewJsonConversions.toJson(r)).
                putOpt(USER_IDENTITY, r.getUserIdentity() == null ?
                        null : UserIdentityJsonConversions.toJson(r.getUserIdentity())).
                putOpt(UID, r.getUid()).
                putOpt(UUID, r.getUuid()).
                putOpt(COMMENT_FROM_BUSINESS, r.getCommentFromBusiness()).
                putOpt(PREVIOUS_VERSION_ID, r.getPreviousVersionId()).
                putOpt(COMMENT, r.getComment() == null ?
                        null : CommentJsonConversions.toJson(r.getComment())).
                putOpt(SOURCE_TYPE, r.getSourceType());
    }

    public static String toJsonString(final UgcBizReview ugcBizReview) throws JSONException {
        JSONObject obj;
        obj = toJson(ugcBizReview);
        return obj.toString();
    }


    /**
     * Use {@link #safeToJsonString(ru.yandex.webmaster3.core.semantic.review_business.biz.model.UgcBizReview)} instead
     */
    @Deprecated
    public static JSONObject safeToJson(final UgcBizReview r) {
        try {
            return toJson(r);
        } catch (JSONException e) {
            log.error("Error while convert UgcBizReview to JSON", e);
            return null;
        }
    }

    public static String safeToJsonString(final UgcBizReview ugcBizReview) {
        try {
            return toJsonString(ugcBizReview);
        } catch (JSONException e) {
            log.error("Error while convert UgcBizReview to JSON", e);
            return null;
        }
    }

}

