package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.Locales;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.*;
import ru.yandex.webmaster3.core.semantic.review_business.model.*;
import ru.yandex.webmaster3.core.semantic.review_business.model.impl.json.UserIdentityOverJson;
import ru.yandex.webmaster3.core.semantic.review_business.util.JsonAccessUtils;

import java.util.*;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.UgcBizReviewAttributes.*;

/**
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class UgcBizReviewOverJson extends UgcBizReview {

    private final JSONObject json;
    private final BizReview bizReview;
    private final UserIdentity userIdentity;
    private final Comment comment;

    /**
     * This implementation breaks the contract for hashCode (because hashCode is counted
     * on top of all get methods of Object and JSONObject is mutable and cannot be controlled from
     * this implementation)
     * Visibility will be changed to package private (in case of necessity
     * of usage in constructing of high-level objects) or removed completely
     */
    @Deprecated
    public UgcBizReviewOverJson(final JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create UgcBizReview over null JSON");
        this.json = json;
        this.bizReview = new BizReviewOverJson(
                json.has("biz-review") ?
                        json.optJSONObject("biz-review") :
                        new JSONObject());
        this.userIdentity = json.has(USER_IDENTITY) ?
                new UserIdentityOverJson(json.optJSONObject(USER_IDENTITY)) : null;
        this.comment = json.has(COMMENT) ?
                new CommentOverJson(json.optJSONObject(COMMENT)) : null;
    }

    public UgcBizReviewOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create UgcBizReview over empty JSON string");
        this.json = new JSONObject(json);
        this.bizReview = new BizReviewOverJson(
                this.json.has("biz-review") ?
                        this.json.optJSONObject("biz-review") :
                        new JSONObject());
        this.userIdentity = this.json.has(USER_IDENTITY) ?
                new UserIdentityOverJson(this.json.optJSONObject(USER_IDENTITY)) : null;
        this.comment = this.json.has(COMMENT) ?
                new CommentOverJson(this.json.optJSONObject(COMMENT)) : null;
    }


    @Override
    public Long getUid() {
        return JsonAccessUtils.optLong(json, UID);
    }

    @Override
    public String getDomain() {
        return json.optString(DOMAIN, null);
    }

    @Override
    public Locale getUiLanguage() {
        return Locales.safeValueOf(json.optString(UI_LANGUAGE, null));
    }

    @Override
    public String getUuid() {
        return json.optString(UUID, null);
    }

    @Override
    public UserIdentity getUserIdentity() {
        return userIdentity;
    }

    @Override
    public String getCommentFromBusiness() {
        return json.optString(COMMENT_FROM_BUSINESS, null);
    }

    @Override
    public String getLanguage() {
        return bizReview.getLanguage();
    }

    @Override
    public String getId() {
        return bizReview.getId();
    }

    @Override
    public Long getBizId() {
        return bizReview.getBizId();
    }

    @Override
    public Long getAutoBizId() {
        return null;
    }

    @Override
    public Set<Long> getExcludedBizIds() {
        return Collections.emptySet();
    }

    @Override
    public Long getChainId() {
        return bizReview.getChainId();
    }

    @Override
    public BizCategory getCategory() {
        return bizReview.getCategory();
    }

    @Override
    public Collection<String> getBizRubrics() {
        return bizReview.getBizRubrics();
    }

    @Override
    public Float getRating() {
        return bizReview.getRating();
    }

    @Override
    public Float getBestRating() {
        return bizReview.getBestRating();
    }

    @Override
    public Float getWorstRating() {
        return bizReview.getWorstRating();
    }

    @Override
    public Author getReviewer() {
        return bizReview.getReviewer();
    }

    @Override
    public HCard getItem() {
        return bizReview.getItem();
    }

    @Override
    public String getSummary() {
        return bizReview.getSummary();
    }

    @Override
    public String getDescription() {
        return bizReview.getDescription();
    }

    @Override
    public Collection<String> getPros() {
        return bizReview.getPros();
    }

    @Override
    public Collection<String> getContras() {
        return bizReview.getContras();
    }

    @Override
    public Integer getUsefulCount() {
        return bizReview.getUsefulCount();
    }

    @Override
    public Integer getUselessCount() {
        return bizReview.getUselessCount();
    }

    @Override
    public Integer getLikesCount() {
        return bizReview.getLikesCount();
    }

    @Override
    public Integer getCommentsCount() {
        return bizReview.getCommentsCount();
    }

    @Override
    public Date getReviewedDate() {
        return bizReview.getReviewedDate();
    }

    @Override
    public String getVisitedDate() {
        return bizReview.getVisitedDate();
    }

    @Override
    public String getReviewsUrl() {
        return bizReview.getReviewsUrl();
    }

    @Override
    public String getCommentsUrl() {
        return bizReview.getCommentsUrl();
    }

    @Override
    public Collection<Tag> getTags() {
        return bizReview.getTags();
    }

    @Override
    public Collection<Tag> getFacts() {
        return bizReview.getFacts();
    }

    @Override
    public String getUrl() {
        return bizReview.getUrl();
    }

    @Override
    public LinkToOriginReview getOriginReview() {
        return bizReview.getOriginReview();
    }

    @Override
    public Long getSourceId() {
        return bizReview.getSourceId();
    }

    @Override
    public String getPermanentId() {
        return bizReview.getPermanentId();
    }

    @Override
    public String getVersionId() {
        return bizReview.getVersionId();
    }

    @Override
    public boolean isDeleted() {
        return bizReview.isDeleted();
    }

    @Override
    public String getPreviousVersionId() {
        return json.optString(PREVIOUS_VERSION_ID, null);
    }

    @Override
    public Comment getComment() {
        return comment;
    }

    @Override
    public List<Moderation2> getModerationHistory() {
        return bizReview.getModerationHistory();
    }

    @Override
    public Date getWatchTime() {
        return bizReview.getWatchTime();
    }

    @Override
    public String getSpecialistId() {
        return bizReview.getSpecialistId();
    }

    @Override
    public boolean isVerified() {
        return bizReview.isVerified();
    }

    @Override
    public Geo getGeo() {
        return bizReview.getGeo();
    }

    @Override
    public SourceType getSourceType() {
        final String st = json.optString(SOURCE_TYPE, null);
        return st == null ? null : SourceType.valueOf(st);
    }
}

