package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;


import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Address;

/**
 * Immutable implementation of {@link Address}
 * that on each modification call returns new instance.
 * <p/>
 * User: willzyx
 * Date: 3/30/12 - 4:32 PM
 */
public class AddressWrapper extends Address {

    /**
     * Static factory.
     * This method should be used
     * for obtain instance of wrapper
     * for further manipulations.
     *
     * @return instance of AddressWrapper over empty Address
     */
    public static AddressWrapper newAddress() {
        return EMPTY_ADDRESS_WRAPPER;
    }

    private final Address address;

    public AddressWrapper(Address address) {
        this.address = address;
    }

    @Override
    public String getCountryName() {
        return address.getCountryName();
    }

    public AddressWrapper setCountryName(final String countryName) {
        return new AddressWrapper(this) {
            @Override
            public String getCountryName() {
                return countryName;
            }
        };
    }

    @Override
    public String getRegion() {
        return address.getRegion();
    }

    public AddressWrapper setRegion(final String region) {
        return new AddressWrapper(this) {
            @Override
            public String getRegion() {
                return region;
            }
        };
    }

    @Override
    public String getLocality() {
        return address.getLocality();
    }

    public AddressWrapper setLocality(final String locality) {
        return new AddressWrapper(this) {
            @Override
            public String getLocality() {
                return locality;
            }
        };
    }

    @Override
    public String getStreetAddress() {
        return address.getStreetAddress();
    }

    public AddressWrapper setStreetAddress(final String streetAddress) {
        return new AddressWrapper(this) {
            @Override
            public String getStreetAddress() {
                return streetAddress;
            }
        };
    }

    @Override
    public String getExtendedAddress() {
        return address.getExtendedAddress();
    }

    public AddressWrapper setExtendedAddress(final String extendedAddress) {
        return new AddressWrapper(this) {
            @Override
            public String getExtendedAddress() {
                return extendedAddress;
            }
        };
    }

    @Override
    public String getPostalCode() {
        return address.getPostalCode();
    }

    public AddressWrapper setPostalCode(final String postalCode) {
        return new AddressWrapper(this) {
            @Override
            public String getPostalCode() {
                return postalCode;
            }
        };
    }

    private static final AddressWrapper EMPTY_ADDRESS_WRAPPER = new AddressWrapper(
            new Address() {
                @Override
                public String getCountryName() {
                    return null;
                }

                @Override
                public String getRegion() {
                    return null;
                }

                @Override
                public String getLocality() {
                    return null;
                }

                @Override
                public String getStreetAddress() {
                    return null;
                }

                @Override
                public String getExtendedAddress() {
                    return null;
                }

                @Override
                public String getPostalCode() {
                    return null;
                }
            }
    );

}

