package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.biz.model.BusinessCard;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.HCard;
import ru.yandex.webmaster3.core.semantic.review_business.model.utilities.ModelDataReader;
import ru.yandex.webmaster3.core.semantic.review_business.model.utilities.ModelDataWriter;
import ru.yandex.webmaster3.core.semantic.review_business.model.utilities.ModelWriteException;

import java.util.Date;

/**
 * User: Evgeny Zhoga <ezhoga@yandex-team.ru>
 * Date: 15.11.13
 */
public class BusinessCardWrapper extends BusinessCard {
    private final BusinessCard businessCard;

    private BusinessCardWrapper(BusinessCard businessCard) {
        this.businessCard = businessCard;
    }

    public static BusinessCardWrapper newBusinessCard(BusinessCard businessCard) {
        return new BusinessCardWrapper(businessCard);
    }

    public static BusinessCardWrapper newBusinessCard(HCard hCard) {
        return newBusinessCard().
                setBizId(hCard.getBizId() != null ? hCard.getBizId() : hCard.getAutoBizId()).
                setSourceId(hCard.getSourceId()).
                setUrl(hCard.getUrl()).
                setLocalUrl(hCard.getLocalUrl());
    }

    public static BusinessCardWrapper newBusinessCard() {
        return new BusinessCardWrapper(EMPTY_BUSINESS_CARD);
    }

    @Override
    public Long getBizId() {
        return businessCard.getBizId();
    }
    public BusinessCardWrapper setBizId(final Long bizId) {
        return new BusinessCardWrapper(this) {
            @Override
            public Long getBizId() {
                return bizId;
            }
        };
    }

    @Override
    public Long getSourceId() {
        return businessCard.getSourceId();
    }
    public BusinessCardWrapper setSourceId(final Long sourceId) {
        return new BusinessCardWrapper(this) {
            @Override
            public Long getSourceId() {
                return sourceId;
            }
        };
    }

    @Override
    public String getUrl() {
        return businessCard.getUrl();
    }
    public BusinessCardWrapper setUrl(final String url) {
        return new BusinessCardWrapper(this) {
            @Override
            public String getUrl() {
                return url;
            }
        };
    }

    @Override
    public String getLocalUrl() {
        return businessCard.getLocalUrl();
    }
    public BusinessCardWrapper setLocalUrl(final String localUrl) {
        return new BusinessCardWrapper(this) {
            @Override
            public String getLocalUrl() {
                return localUrl;
            }
        };
    }

    @Override
    public String getSnippet() {
        return businessCard.getSnippet();
    }
    public BusinessCardWrapper setSnippet(final String snippet) {
        return new BusinessCardWrapper(this) {
            @Override
            public String getSnippet() {
                return snippet;
            }
        };
    }

    @Override
    public Date getWatchTime() {
        return businessCard.getWatchTime();
    }
    public BusinessCardWrapper setWatchTime(final Date watchTime) {
        final Date copy = new Date(watchTime.getTime());
        return new BusinessCardWrapper(this) {
            @Override
            public Date getWatchTime() {
                return copy;
            }
        };
    }

    private final static BusinessCard EMPTY_BUSINESS_CARD = new BusinessCard() {
        @Override
        public Long getBizId() {
            return null;
        }

        @Override
        public Long getSourceId() {
            return null;
        }

        @Override
        public String getUrl() {
            return null;
        }

        @Override
        public String getLocalUrl() {
            return null;
        }

        @Override
        public String getSnippet() {
            return null;
        }

        @Override
        public Date getWatchTime() {
            return null;
        }
    };

    public static BusinessCard read(ModelDataReader reader) {
        return newBusinessCard().
                setBizId(reader.getLong(BIZ_ID)).
                setSourceId(reader.getLong(SOURCE_ID)).
                setUrl(reader.getString(URL)).
                setLocalUrl(reader.getString(LOCAL_URL)).
                setSnippet(reader.getString(SNIPPET)).
                setWatchTime(reader.getDate(WATCH_TIME));

    }
    public static void write(ModelDataWriter<?> writer, BusinessCard businessCard) throws ModelWriteException {
        writer.put(BIZ_ID, businessCard.getBizId());
        writer.put(SOURCE_ID, businessCard.getSourceId());
        writer.put(URL, businessCard.getUrl());
        writer.put(LOCAL_URL, businessCard.getLocalUrl());
        writer.put(SNIPPET, businessCard.getSnippet());
        writer.put(WATCH_TIME, businessCard.getWatchTime());
    }

}

