package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Comment;

import java.util.Date;

/**
 * Immutable implementation of {@link Comment}.
 * Each modification produces new instance.
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class CommentWrapper extends Comment {

    public static CommentWrapper newComment() {
        return EMPTY_COMMENT;
    }

    private final Comment comment;

    public CommentWrapper(final Comment comment) {
        if (comment == null)
            throw new NullPointerException("Unable to wrap null comment");
        this.comment = comment;
    }

    @Override
    public String getText() {
        return comment.getText();
    }

    public CommentWrapper setText(final String text) {
        return new CommentWrapper(this) {
            @Override
            public String getText() {
                return text;
            }
        };
    }

    @Override
    public Date getPublishedDate() {
        return comment.getPublishedDate();
    }

    public CommentWrapper setPublishedDate(final Date date) {
        return new CommentWrapper(this) {
            @Override
            public Date getPublishedDate() {
                return date;
            }
        };
    }

    @Override
    public Long getBizId() {
        return comment.getBizId();
    }

    public CommentWrapper setBizId(final Long bizId) {
        return new CommentWrapper(this) {
            @Override
            public Long getBizId() {
                return bizId;
            }
        };
    }

    @Override
    public String getReviewId() {
        return comment.getReviewId();
    }

    public CommentWrapper setReviewId(final String reviewId) {
        return new CommentWrapper(this) {
            @Override
            public String getReviewId() {
                return reviewId;
            }
        };
    }

    @Override
    public Long getReviewAuthorUid() {
        return comment.getReviewAuthorUid();
    }

    public CommentWrapper setReviewAuthorUid(final Long reviewAuthorUid) {
        return new CommentWrapper(this) {
            @Override
            public Long getReviewAuthorUid() {
                return reviewAuthorUid;
            }
        };
    }

    private static final CommentWrapper EMPTY_COMMENT = new CommentWrapper(
            new Comment() {
                @Override
                public String getText() {
                    return null;
                }

                @Override
                public Date getPublishedDate() {
                    return null;
                }

                @Override
                public Long getBizId() {
                    return null;
                }

                @Override
                public String getReviewId() {
                    return null;
                }

                @Override
                public Long getReviewAuthorUid() {
                    return null;
                }
            }
    );
}

