package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Complaint;

import java.util.Date;

/**
 * Immutable implementation of {@link Complaint}.
 * Each modification will produce new instance.
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class ComplaintWrapper extends Complaint {

    private final Complaint complaint;

    public static ComplaintWrapper newComplaint() {
        return new ComplaintWrapper(EMPTY);
    }

    public ComplaintWrapper(final Complaint complaint) {
        if (complaint == null)
            throw new NullPointerException("Unable to wrap null complaint");
        this.complaint = complaint;
    }

    @Override
    public String getId() {
        return complaint.getId();
    }

    public ComplaintWrapper setId(final String id) {
        return new ComplaintWrapper(this) {
            @Override
            public String getId() {
                return id;
            }
        };
    }

    @Override
    public Long getBizId() {
        return complaint.getBizId();
    }

    public ComplaintWrapper setBizId(final Long bizId) {
        return new ComplaintWrapper(this) {
            @Override
            public Long getBizId() {
                return bizId;
            }
        };
    }

    @Override
    public String getReviewId() {
        return complaint.getReviewId();
    }

    public ComplaintWrapper setReviewId(final String reviewId) {
        return new ComplaintWrapper(this) {
            @Override
            public String getReviewId() {
                return reviewId;
            }
        };
    }

    @Override
    public Reason getReason() {
        return complaint.getReason();
    }

    public ComplaintWrapper setReason(final Reason reason) {
        return new ComplaintWrapper(this) {
            @Override
            public Reason getReason() {
                return reason;
            }
        };
    }

    @Override
    public String getText() {
        return complaint.getText();
    }

    public ComplaintWrapper setText(final String text) {
        return new ComplaintWrapper(this) {
            @Override
            public String getText() {
                return text;
            }
        };
    }

    @Override
    public CheckStatus getCheckStatus() {
        return complaint.getCheckStatus();
    }

    public ComplaintWrapper setCheckStatus(final Complaint.CheckStatus status) {
        return new ComplaintWrapper(this) {
            @Override
            public CheckStatus getCheckStatus() {
                return status;
            }
        };
    }

    @Override
    public String getCheckMessage() {
        return complaint.getCheckMessage();
    }

    public ComplaintWrapper setCheckMessage(final String checkMessage) {
        return new ComplaintWrapper(this) {
            @Override
            public String getCheckMessage() {
                return checkMessage;
            }
        };
    }

    @Override
    public Date getCreationDate() {
        return complaint.getCreationDate();
    }

    public ComplaintWrapper setCreationDate(final Date creationDate) {
        return new ComplaintWrapper(this) {
            @Override
            public Date getCreationDate() {
                return creationDate;
            }
        };
    }

    @Override
    public Long getHandlerUid() {
        return complaint.getHandlerUid();
    }

    public ComplaintWrapper setHandlerUid(final Long uid) {
        return new ComplaintWrapper(this) {
            @Override
            public Long getHandlerUid() {
                return uid;
            }
        };
    }

    @Override
    public Date getHandledTime() {
        return complaint.getHandledTime();
    }

    public ComplaintWrapper setHandledTime(final Date time) {
        return new ComplaintWrapper(this) {
            @Override
            public Date getHandledTime() {
                return time;
            }
        };
    }

    private static final Complaint EMPTY = new Complaint() {
        @Override
        public String getId() {
            return null;
        }

        @Override
        public Long getBizId() {
            return null;
        }

        @Override
        public String getReviewId() {
            return null;
        }

        @Override
        public Reason getReason() {
            return null;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public CheckStatus getCheckStatus() {
            return null;
        }

        @Override
        public String getCheckMessage() {
            return null;
        }

        @Override
        public Date getCreationDate() {
            return null;
        }

        @Override
        public Long getHandlerUid() {
            return null;
        }

        @Override
        public Date getHandledTime() {
            return null;
        }
    };
}

