package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Feature;

/**
 * TODO
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class FeatureWrapper extends Feature {

    public static FeatureWrapper newFeature() {
        return EMPTY_FEATURE_WRAPPER;
    }

    public static FeatureWrapper newFeature(final String name, final String value) {
        return new FeatureWrapper(
                new Feature() {
                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public String getValue() {
                        return value;
                    }
                }
        );
    }

    private final Feature feature;

    public FeatureWrapper(final Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Unable to wrap null feature");
        }
        this.feature = feature;
    }

    @Override
    public String getName() {
        return feature.getName();
    }

    public FeatureWrapper setName(final String name) {
        return new FeatureWrapper(this) {
            @Override
            public String getName() {
                return name;
            }
        };
    }

    @Override
    public String getValue() {
        return feature.getValue();
    }

    public FeatureWrapper setValue(final String value) {
        return new FeatureWrapper(this) {
            @Override
            public String getValue() {
                return value;
            }
        };
    }

    private static final FeatureWrapper EMPTY_FEATURE_WRAPPER =
            new FeatureWrapper(new Feature() {
                @Override
                public String getName() {
                    return null;
                }

                @Override
                public String getValue() {
                    return null;
                }
            });
}

