package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Geo;

public class GeoWrapper extends Geo {

    private final Geo geo;

    public GeoWrapper(final Geo geo) {
        this.geo = geo;
    }

    public GeoWrapper set(final Float lat, final Float lon) {
        return new GeoWrapper(new Geo() {
            @Override
            public Float getLatitude() {
                return lat;
            }

            @Override
            public Float getLongitude() {
                return lon;
            }
        });
    }

    @Override
    public Float getLatitude() {
        return geo.getLatitude();
    }

    @Override
    public Float getLongitude() {
        return geo.getLongitude();
    }

    public static GeoWrapper newGeo() {
        return new GeoWrapper(new Geo() {
            @Override
            public Float getLatitude() {
                return null;
            }

            @Override
            public Float getLongitude() {
                return null;
            }
        });

    }
}
