package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;

import com.google.common.collect.Lists;
import ru.yandex.webmaster3.core.semantic.review_business.biz.model.*;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;

/**
 * TODO
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class HCardWrapper extends HCard {

    public static HCardWrapper newHCard() {
        return EMPTY_HCARD_WRAPPER;
    }

    private final HCard hCard;

    public HCardWrapper(final HCard hCard) {
        if (hCard == null) {
            throw new IllegalArgumentException("Unable to wrap null hCard");
        }
        this.hCard = hCard;
    }

    @Override
    public Long getBizId() {
        return hCard.getBizId();
    }

    public HCardWrapper setBizId(final Long bizId) {
        return new HCardWrapper(this) {
            @Override
            public Long getBizId() {
                return bizId;
            }
        };
    }

    @Override
    public Long getAutoBizId() {
        return hCard.getAutoBizId();
    }

    public HCardWrapper setAutoBizId(final Long autoBizId) {
        return new HCardWrapper(this) {
            @Override
            public Long getAutoBizId() {
                return autoBizId;
            }
        };
    }

    @Override
    public Collection<Long> getExcludedBizIds() {
        return hCard.getExcludedBizIds();
    }

    public HCardWrapper setExcludedBizIds(final Collection<Long> bizIds) {
        return new HCardWrapper(this) {
            @Override
            public Collection<Long> getExcludedBizIds() {
                return Collections.unmodifiableCollection(bizIds);
            }
        };
    }

    @Override
    public BizCategory getCategory() {
        return hCard.getCategory();
    }

    public HCardWrapper setCategory(final BizCategory category) {
        return new HCardWrapper(this) {
            @Override
            public BizCategory getCategory() {
                return category;
            }
        };
    }

    @Override
    public String getFn() {
        return hCard.getFn();
    }

    public HCardWrapper setFn(final String fn) {
        return new HCardWrapper(this) {
            @Override
            public String getFn() {
                return fn;
            }
        };
    }

    @Override
    public Collection<String> getAltNames() {
        return hCard.getAltNames();
    }

    public HCardWrapper setAltNames(final Collection<String> altNames) {
        return new HCardWrapper(this) {
            @Override
            public Collection<String> getAltNames() {
                return Collections.unmodifiableCollection(altNames);
            }
        };
    }

    public HCardWrapper setAltNames(final String... altNames) {
        return setAltNames(Lists.newArrayList(altNames));
    }

    @Override
    public Collection<Address> getAddresses() {
        return hCard.getAddresses();
    }

    public HCardWrapper setAddresses(final Collection<Address> addresses) {
        return new HCardWrapper(this) {
            @Override
            public Collection<Address> getAddresses() {
                return Collections.unmodifiableCollection(addresses);
            }
        };
    }

    public HCardWrapper setAddresses(final Address... addresses) {
        return setAddresses(Lists.newArrayList(addresses));
    }

    @Override
    public String getUrl() {
        return hCard.getUrl();
    }

    public HCardWrapper setUrl(final String url) {
        return new HCardWrapper(this) {
            @Override
            public String getUrl() {
                return url;
            }
        };
    }

    @Override
    public String getLocalUrl() {
        return hCard.getLocalUrl();
    }

    public HCardWrapper setLocalUrl(final String localUrl) {
        return new HCardWrapper(this) {
            @Override
            public String getLocalUrl() {
                return localUrl;
            }
        };
    }

    @Override
    public String getEmail() {
        return hCard.getEmail();
    }

    @Override
    public Geo getGeo() {
        return hCard.getGeo();
    }

    public HCardWrapper setGeo(final Geo geo) {
        return new HCardWrapper(this) {
            @Override
            public Geo getGeo() {
                return geo;
            }
        };
    }

    public HCardWrapper setEmail(final String email) {
        return new HCardWrapper(this) {
            @Override
            public String getEmail() {
                return email;
            }
        };
    }

    @Override
    public String getPhoneNumber() {
        return hCard.getPhoneNumber();
    }

    public HCardWrapper setPhoneNumber(final String phoneNumber) {
        return new HCardWrapper(this) {
            @Override
            public String getPhoneNumber() {
                return phoneNumber;
            }
        };
    }

    @Override
    public String getWorkHours() {
        return hCard.getWorkHours();
    }

    public HCardWrapper setWorkHours(final String workHours) {
        return new HCardWrapper(this) {
            @Override
            public String getWorkHours() {
                return workHours;
            }
        };
    }

    @Override
    public String getPhotoUrl() {
        return hCard.getPhotoUrl();
    }

    public HCardWrapper setPhotoUrl(final String photoUrl) {
        return new HCardWrapper(this) {
            @Override
            public String getPhotoUrl() {
                return photoUrl;
            }
        };
    }

    @Override
    public String getLogoUrl() {
        return hCard.getLogoUrl();
    }

    public HCardWrapper setLogoUrl(final String logoUrl) {
        return new HCardWrapper(this) {
            @Override
            public String getLogoUrl() {
                return logoUrl;
            }
        };
    }

    @Override
    public Collection<Feature> getFeatures() {
        return hCard.getFeatures();
    }

    public HCardWrapper setFeatures(final Collection<Feature> features) {
        return new HCardWrapper(this) {
            @Override
            public Collection<Feature> getFeatures() {
                return Collections.unmodifiableCollection(features);
            }
        };
    }

    public HCardWrapper setFeatures(final Feature... features) {
        return setFeatures(Lists.newArrayList(features));
    }

    @Override
    public Long getSourceId() {
        return hCard.getSourceId();
    }

    public HCardWrapper setSourceId(final Long sourceId) {
        return new HCardWrapper(this) {
            @Override
            public Long getSourceId() {
                return sourceId;
            }
        };
    }

    @Override
    public Date getWatchTime() {
        return hCard.getWatchTime();
    }

    public HCardWrapper setWatchTime(final Date watchTime) {
        return new HCardWrapper(this) {
            @Override
            public Date getWatchTime() {
                return watchTime;
            }
        };
    }


    private static final HCardWrapper EMPTY_HCARD_WRAPPER = new HCardWrapper(
            new HCard() {
                @Override
                public Long getBizId() {
                    return null;
                }

                @Override
                public Long getAutoBizId() {
                    return null;
                }

                @Override
                public Collection<Long> getExcludedBizIds() {
                    return Collections.emptyList();
                }

                @Override
                public BizCategory getCategory() {
                    return null;
                }

                @Override
                public String getFn() {
                    return null;
                }

                @Override
                public Collection<String> getAltNames() {
                    return Collections.emptyList();
                }

                @Override
                public Collection<Address> getAddresses() {
                    return Collections.emptyList();
                }

                @Override
                public String getUrl() {
                    return null;
                }

                @Override
                public String getLocalUrl() {
                    return null;
                }

                @Override
                public String getEmail() {
                    return null;
                }

                @Override
                public Geo getGeo() {
                    return null;
                }

                @Override
                public String getPhoneNumber() {
                    return null;
                }

                @Override
                public String getWorkHours() {
                    return null;
                }

                @Override
                public String getPhotoUrl() {
                    return null;
                }

                @Override
                public String getLogoUrl() {
                    return null;
                }

                @Override
                public Collection<Feature> getFeatures() {
                    return Collections.emptyList();
                }

                @Override
                public Long getSourceId() {
                    return null;
                }

                @Override
                public Date getWatchTime() {
                    return null;
                }
            }
    );

}

