package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Moderation2;

import java.util.Date;

/**
 * Immutable implementation of {@link ru.yandex.webmaster3.core.semantic.review_business.biz.model.Moderation}
 * that on each modification call returns new instance.
 *
 * @author ezhoga
 * @author dimas
 */
public class Moderation2Wrapper extends Moderation2 {

    public static Moderation2Wrapper newModeration() {
        return EMPTY_WRAPPER;
    }

    private final Moderation2 moderation;

    public Moderation2Wrapper(final Moderation2 moderation) {
        if (moderation == null)
            throw new NullPointerException("Unable to wrap null Moderation");
        this.moderation = moderation;
    }

    @Override
    public RejReason getRejectionReason() {
        return moderation.getRejectionReason();
    }

    public Moderation2Wrapper setRejectionReason(final Moderation2.RejReason reason) {
        return new Moderation2Wrapper(this) {
            @Override
            public RejReason getRejectionReason() {
                return reason;
            }
        };
    }

    @Override
    public Status getStatus() {
        return moderation.getStatus();
    }

    public Moderation2Wrapper setStatus(final Moderation2.Status status) {
        return new Moderation2Wrapper(this) {
            @Override
            public Status getStatus() {
                return status;
            }
        };
    }

    @Override
    public String getRejectionText() {
        return moderation.getRejectionText();
    }

    public Moderation2Wrapper setRejectionText(final String text) {
        return new Moderation2Wrapper(this) {
            @Override
            public String getRejectionText() {
                return text;
            }
        };
    }

    @Override
    public String getCustomRejectionText() {
        return moderation.getCustomRejectionText();
    }

    public Moderation2Wrapper setCustomRejectionText(final String text) {
        return new Moderation2Wrapper(this) {
            @Override
            public String getCustomRejectionText() {
                return text;
            }
        };
    }

    @Override
    public Handler getHandler() {
        return moderation.getHandler();
    }

    public Moderation2Wrapper setHandler(final Moderation2.Handler handler) {
        return new Moderation2Wrapper(this) {
            @Override
            public Handler getHandler() {
                return handler;
            }
        };
    }

    @Override
    public Date getTime() {
        return moderation.getTime();
    }

    public Moderation2Wrapper setTime(final Date time) {
        return new Moderation2Wrapper(this) {
            @Override
            public Date getTime() {
                return time;
            }
        };
    }

    @Override
    public String getNote() {
        return moderation.getNote();
    }

    public Moderation2Wrapper setNote(final String note) {
        return new Moderation2Wrapper(this) {
            @Override
            public String getNote() {
                return note;
            }
        };
    }

    private static final Moderation2Wrapper EMPTY_WRAPPER = new Moderation2Wrapper(
            new Moderation2() {
                @Override
                public Status getStatus() {
                    return null;
                }

                @Override
                public RejReason getRejectionReason() {
                    return null;
                }

                @Override
                public String getRejectionText() {
                    return null;
                }

                @Override
                public String getCustomRejectionText() {
                    return null;
                }

                @Override
                public Handler getHandler() {
                    return null;
                }

                @Override
                public Date getTime() {
                    return null;
                }

                @Override
                public String getNote() {
                    return null;
                }
            });
}
