package ru.yandex.webmaster3.core.semantic.review_business.biz.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.biz.model.Tag;

/**
 * TODO
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class TagWrapper extends Tag {

    public static TagWrapper newTag() {
        return EMPTY_TAG_WRAPPER;
    }

    private final Tag tag;

    public TagWrapper(final Tag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Unable to wrap null tag");
        }
        this.tag = tag;
    }

    @Override
    public String getValue() {
        return tag.getValue();
    }

    public TagWrapper setValue(final String value) {
        return new TagWrapper(this) {
            @Override
            public String getValue() {
                return value;
            }
        };
    }

    @Override
    public String getName() {
        return tag.getName();
    }

    public TagWrapper setName(final String name) {
        return new TagWrapper(this) {
            @Override
            public String getName() {
                return name;
            }
        };
    }

    @Override
    public Type getType() {
        return tag.getType();
    }

    public TagWrapper setType(final Tag.Type type) {
        return new TagWrapper(this) {
            @Override
            public Type getType() {
                return type;
            }
        };
    }

    @Override
    public String getCaption() {
        return tag.getCaption();
    }

    public TagWrapper setCaption(final String caption) {
        return new TagWrapper(this) {
            @Override
            public String getCaption() {
                return caption;
            }
        };
    }

    private static final TagWrapper EMPTY_TAG_WRAPPER =
            new TagWrapper(new Tag() {
                @Override
                public String getValue() {
                    return null;
                }

                @Override
                public String getName() {
                    return null;
                }

                @Override
                public Type getType() {
                    return null;
                }

                @Override
                public String getCaption() {
                    return null;
                }
            });
}

