package ru.yandex.webmaster3.core.semantic.review_business.model;

import ru.yandex.webmaster3.core.semantic.review_business.ModelUtils;
import ru.yandex.webmaster3.core.semantic.review_business.model.impl.json.SocialJsonConversions;

/**
 * Represents social part of data for author. Avalable only for authors authorized via
 * social accounts (like twitter, vk etc.)
 * Date: 6/11/12
 * Author: Evgeny Zhoga (ezhoga@yandex-team.ru)
 */
public abstract class Social {
    /**
     * Socail info provider name ("vkontakte", "twitter" etc.)
     */
    public abstract String getProvider();

    /**
     * User name in social network
     */
    public abstract String getUsername();

    /**
     * Social network user identifier
     */
    public abstract String getUserId();

    /**
     * Social profile identifier. Used to request info from PROXY
     */
    public abstract Long getProfileId();

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof Social)) return false;

        final Social author = (Social) o;

        return hashCode() == o.hashCode()
                && ModelUtils.equals(getProvider(), author.getProvider())
                && ModelUtils.equals(getUsername(), author.getUsername())
                && ModelUtils.equals(getUserId(), author.getUserId())
                && ModelUtils.equals(getProfileId(), author.getProfileId());
    }

    @Override
    public int hashCode() {
        return ModelUtils.hashCode(
                getProvider()
                , getUsername()
                , getUserId()
                , getProfileId()
        );
    }

    @Override
    public String toString() {
        return SocialJsonConversions.toJsonString(this, 1);
    }
}
