package ru.yandex.webmaster3.core.semantic.review_business.model.impl.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.model.Author;
import ru.yandex.webmaster3.core.semantic.review_business.model.Social;
import ru.yandex.webmaster3.core.semantic.review_business.util.DateHelper;
import ru.yandex.webmaster3.core.semantic.review_business.util.JsonAccessUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.model.impl.AuthorAttributes.*;

/**
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class AuthorOverJson extends Author {
    private static final Logger log = LoggerFactory.getLogger(AuthorOverJson.class);

    private final JSONObject json;

    /**
     * This implementation breaks the contract for hashCode (because hashCode is counted
     * on top of all get methods of Object and JSONObject is mutable and cannot be controlled from
     * this implementation)
     * Visibility will be changed to package private (in case of necessity
     * of usage in constructing of high-level objects) or removed completely
     */
    @Deprecated
    public AuthorOverJson(final JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create Author over null JSON");
        this.json = json;
    }
    public AuthorOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create Author over empty JSON string");
            this.json = new JSONObject(json);
    }

    @Override
    public String getFn() {
        return json.optString(FN, null);
    }

    @Override
    public String getLogin() {
        return json.optString(LOGIN, null);
    }

    @Override
    public String getDisplayName() {
        return json.optString(DISPLAY_NAME, null);
    }

    @Override
    public SignPrivacy getSignPrivacy() {
        String value = json.optString(SIGN_PRIVACY, null);
        if (value == null) return SignPrivacy.NAME;
        else return SignPrivacy.valueOf(value);
    }

    @Override
    public String getUrl() {
        return json.optString(URL, null);
    }

    @Override
    public String getEmail() {
        return json.optString(EMAIL, null);
    }

    @Override
    public String getAvatarUrl() {
        return json.optString(AVATAR, null);
    }

    @Override
    public Integer getThanksCount() {
        return JsonAccessUtils.optInt(json, THANKS);
    }

    @Override
    public Integer getPostsCount() {
        return JsonAccessUtils.optInt(json, AUTHPOST);
    }

    @Override
    public Integer getCommentsCount() {
        return JsonAccessUtils.optInt(json, AUTHCOMMENTS);
    }

    @Override
    public Integer getFriendsCount() {
        return JsonAccessUtils.optInt(json, FRIENDS);
    }

    @Override
    public Float getKarma() {
        return JsonAccessUtils.optFloat(json, KARMA);
    }

    @Override
    public Date getRegdate() {
        return DateHelper.read(json.optString(REGDATE));
    }

    @Override
    public Collection<Social> getSocials() {
        try {
            return Collections2.transform(
                    JsonAccessUtils.arrayToJsons(json.optJSONArray(SOCIAL)),
                    SocialJsonConversions.JSON_TO_SOCIAL);
        } catch (JSONException e) {
            log.error("Error while getting socials from JSON", e);
            return Collections.emptyList();
        }
    }
}

