package ru.yandex.webmaster3.core.semantic.review_business.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.model.Social;
import ru.yandex.webmaster3.core.semantic.review_business.util.JsonAccessUtils;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.model.impl.SocialAttributes.*;

/**
 * @author: ishalaru
 * DATE: 14.10.2019
 */
public class SocialOverJson extends Social {
    private final JSONObject json;

    SocialOverJson(final JSONObject json) {
        this.json = json;
    }

    public SocialOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create Social over empty JSON string");
        this.json = new JSONObject(json);
    }

    @Override
    public String getProvider() {
        return json.optString(PROVIDER, null);
    }

    @Override
    public String getUsername() {
        return json.optString(USERNAME, null);
    }

    @Override
    public String getUserId() {
        return json.optString(USERID, null);
    }

    @Override
    public Long getProfileId() {
        return JsonAccessUtils.optLong(json, PROFILE_ID);
    }
}
