package ru.yandex.webmaster3.core.semantic.review_business.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.semantic.review_business.model.UserIdentity;

import static ru.yandex.webmaster3.core.semantic.review_business.model.impl.UserIdentityAttributes.*;

/**
 * Helps to convert {@link UserIdentity} to {@link JSONObject}
 * and vise versa.
 *
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public final class UserIdentityJsonConversions {
    private static final Logger log = LoggerFactory.getLogger(UserIdentityJsonConversions.class);

    private UserIdentityJsonConversions() {
    }

    /**
     * Use {@link #fromJson(String)} (throws {@link JSONException}) and {@link #safeFromJson(String)} instead
     */
    @Deprecated
    public static UserIdentity fromJson(final JSONObject json) {
        return new UserIdentityOverJson(json);
    }

    public static UserIdentity fromJson(final String json) throws JSONException {
        return new UserIdentityOverJson(json);
    }

    public static UserIdentity safeFromJson(final String json) {
        try {
            return fromJson(json);
        } catch (JSONException e) {
            log.error("Error while parsing UserIdentity from json", e);
            return null;
        }
    }

    /**
     * Use {@link #toJsonString(UserIdentity)} instead
     */
    @Deprecated
    public static JSONObject toJson(final UserIdentity ui) throws JSONException {
        Preconditions.checkNotNull(ui, "Unable to convert null UserIdentity to JSON");
        return new JSONObject().
                putOpt(YANDEX_UID, ui.getYandexUid()).
                putOpt(FLASH_UID_01, ui.getFUid01()).
                putOpt(USER_AGENT, ui.getUserAgent()).
                putOpt(IP, ui.getIp());

    }

    public static String toJsonString(final UserIdentity ui) throws JSONException {
        JSONObject obj;
        obj = toJson(ui);
        return obj.toString();
    }

    /**
     * Use {@link #safeToJsonString(UserIdentity)} instead
     */
    @Deprecated
    public static JSONObject safeToJson(final UserIdentity ui) {
        try {
            return toJson(ui);
        } catch (JSONException e) {
            log.error("Error while convert UserIdentity to JSON", e);
            return null;
        }
    }

    public static String safeToJsonString(final UserIdentity ui) {
        try {
            return toJsonString(ui);
        } catch (JSONException e) {
            log.error("Error while convert UserIdentity to JSON", e);
            return null;
        }
    }
}

