package ru.yandex.webmaster3.core.semantic.review_business.model.impl.json;

import com.google.common.base.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.model.UserIdentity;

import static com.google.common.base.Strings.emptyToNull;
import static ru.yandex.webmaster3.core.semantic.review_business.model.impl.UserIdentityAttributes.*;

/**
 * @author Dima Schitinin <dimas@yandex-team.ru>
 */
public class UserIdentityOverJson extends UserIdentity {
    private final JSONObject json;

    /**
     * This implementation breaks the contract for hashCode (because hashCode is counted
     * on top of all get methods of Object and JSONObject is mutable and cannot be controlled from
     * this implementation)
     * Visibility will be changed to package private (in case of necessity
     * of usage in constructing of high-level objects) or removed completely
     */
    @Deprecated
    public UserIdentityOverJson(final JSONObject json) {
        Preconditions.checkNotNull(json, "Unable to create UserIdentity over null JSON");
        this.json = json;
    }
    public UserIdentityOverJson(final String json) throws JSONException {
        Preconditions.checkNotNull(emptyToNull(json), "Unable to create UserIdentity over empty JSON string");
            this.json = new JSONObject(json);
    }

    @Override
    public String getYandexUid() {
        return json.optString(YANDEX_UID, null);
    }

    @Override
    public String getFUid01() {
        return json.optString(FLASH_UID_01, null);
    }

    @Override
    public String getUserAgent() {
        return json.optString(USER_AGENT, null);
    }

    @Override
    public String getIp() {
        return json.optString(IP, null);
    }
}

