package ru.yandex.webmaster3.core.semantic.review_business.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.model.LinkToOriginReview;

import java.util.Date;

/**
 * User: willzyx
 * Date: 9/20/12 - 6:00 PM
 */
public class LinkToOriginReviewWrapper extends LinkToOriginReview {
    private final LinkToOriginReview link;

    public LinkToOriginReviewWrapper(LinkToOriginReview link) {
        this.link = link;
    }

    @Override
    public String originReviewId() {
        return link.originReviewId();
    }

    public LinkToOriginReviewWrapper setOriginReviewId(final String id) {
        return new LinkToOriginReviewWrapper(this) {
            @Override
            public String originReviewId() {
                return id;
            }
        };
    }

    @Override
    public Date linkMountAt() {
        return link.linkMountAt();
    }

    public LinkToOriginReviewWrapper setLinkMountAt(final Date time) {
        return new LinkToOriginReviewWrapper(this) {
            @Override
            public Date linkMountAt() {
                return time;
            }
        };
    }

    @Override
    public Date linkExpireAt() {
        return link.linkExpireAt();
    }

    public LinkToOriginReviewWrapper setLinkExpireAt(final Date time) {
        return new LinkToOriginReviewWrapper(this) {
            @Override
            public Date linkExpireAt() {
                return time;
            }
        };
    }

    public static LinkToOriginReviewWrapper newLink() {
        return new LinkToOriginReviewWrapper(
                new LinkToOriginReview() {
                    @Override
                    public String originReviewId() {
                        return null;
                    }

                    @Override
                    public Date linkMountAt() {
                        return new Date();
                    }

                    @Override
                    public Date linkExpireAt() {
                        return new Date();
                    }
                }
        );
    }
}

