package ru.yandex.webmaster3.core.semantic.review_business.model.impl.wrapper;

import com.google.common.base.Preconditions;
import ru.yandex.webmaster3.core.semantic.review_business.model.ReviewModeration;

import java.util.Date;

/**
 * Immutable implementation of {@link ru.yandex.webmaster3.core.semantic.review_business.model.ReviewModeration}
 * that on each modification call returns new instance.
 *
 * @author ezhoga
 * @author dimas
 */
public class ReviewModerationWrapper extends ReviewModeration {

    private final ReviewModeration moderation;

    protected ReviewModerationWrapper(final ReviewModeration moderation) {
        Preconditions.checkNotNull(moderation, "Unable to wrap null ReviewModeration");

        this.moderation = moderation;
    }

    @Override
    public Status getStatus() {
        return moderation.getStatus();
    }

    public ReviewModerationWrapper setStatus(final Status status) {
        return new ReviewModerationWrapper(this) {
            @Override
            public Status getStatus() {
                return status;
            }
        };
    }

    @Override
    public String getCustomRejectionText() {
        return moderation.getCustomRejectionText();
    }

    public ReviewModerationWrapper setCustomRejectionText(final String text) {
        return new ReviewModerationWrapper(this) {
            @Override
            public String getCustomRejectionText() {
                return text;
            }
        };
    }

    @Override
    public Handler getHandler() {
        return moderation.getHandler();
    }

    public ReviewModerationWrapper setHandler(final Handler handler) {
        return new ReviewModerationWrapper(this) {
            @Override
            public Handler getHandler() {
                return handler;
            }
        };
    }

    @Override
    public Date getTime() {
        return moderation.getTime();
    }

    public ReviewModerationWrapper setTime(final Date time) {
        return new ReviewModerationWrapper(this) {
            @Override
            public Date getTime() {
                return time;
            }
        };
    }

    @Override
    public String getNote() {
        return moderation.getNote();
    }

    public ReviewModerationWrapper setNote(final String note) {
        return new ReviewModerationWrapper(this) {
            @Override
            public String getNote() {
                return note;
            }
        };
    }
    @Override
    public String getRejectionText() {
        return moderation.getRejectionText();
    }

    public ReviewModerationWrapper setRejectionText(final String rejectionText) {
        return new ReviewModerationWrapper(this) {
            @Override
            public String getRejectionText() {
                return rejectionText;
            }
        };
    }

}
