package ru.yandex.webmaster3.core.semantic.review_business.model.impl.wrapper;

import ru.yandex.webmaster3.core.semantic.review_business.model.Social;

/**
 * Date: 6/11/12
 * Author: Evgeny Zhoga (ezhoga@yandex-team.ru)
 */
public class SocialWrapper extends Social {
    private final Social delegate;

    public static SocialWrapper newSocial() {
        return EMPTY_SOCIAL_WRAPPER;
    }

    public SocialWrapper(Social social) {
        this.delegate = social;
    }

    @Override
    public String getProvider() {
        return delegate.getProvider();
    }

    public SocialWrapper setProvider(final String provider) {
        return new SocialWrapper(this) {
            @Override
            public String getProvider() {
                return provider;
            }
        };
    }

    @Override
    public String getUsername() {
        return delegate.getUsername();
    }

    public SocialWrapper setUsername(final String username) {
        return new SocialWrapper(this) {
            @Override
            public String getUsername() {
                return username;
            }
        };
    }

    @Override
    public String getUserId() {
        return delegate.getUserId();
    }

    public SocialWrapper setUserId(final String userid) {
        return new SocialWrapper(this) {
            @Override
            public String getUserId() {
                return userid;
            }
        };
    }

    @Override
    public Long getProfileId() {
        return delegate.getProfileId();
    }

    public SocialWrapper setProfileId(final Long profileId) {
        return new SocialWrapper(this) {
            @Override
            public Long getProfileId() {
                return profileId;
            }
        };
    }

    private static final SocialWrapper EMPTY_SOCIAL_WRAPPER = new SocialWrapper(new Social() {
        @Override
        public String getProvider() {
            return null;
        }

        @Override
        public String getUsername() {
            return null;
        }

        @Override
        public String getUserId() {
            return null;
        }

        @Override
        public Long getProfileId() {
            return null;
        }
    });
}

