package ru.yandex.webmaster3.core.semantic.review_business.model.utilities.json;

import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.model.utilities.ModelDataReader;
import ru.yandex.webmaster3.core.semantic.review_business.util.DateHelper;
import ru.yandex.webmaster3.core.semantic.review_business.util.JsonAccessUtils;

import java.util.Date;

/**
 * User: Evgeny Zhoga <ezhoga@yandex-team.ru>
 * Date: 18.11.13
 */
public class JsonDataReader implements ModelDataReader {
    private final JSONObject json;

    public JsonDataReader(JSONObject json) {
        this.json = json;
    }

    @Override
    public String getString(String name) {
        return json.optString(name);
    }

    @Override
    public Integer getInt(String name) {
        return JsonAccessUtils.optInt(json, name);
    }

    @Override
    public Long getLong(String name) {
        return JsonAccessUtils.optLong(json, name);
    }

    @Override
    public Float getFloat(String name) {
        return JsonAccessUtils.optFloat(json, name);
    }

    @Override
    public Double getDouble(String name) {
        return JsonAccessUtils.optDouble(json, name);
    }

    @Override
    public Boolean getBoolean(String name) {
        return JsonAccessUtils.optBoolean(json, name);
    }

    @Override
    public Date getDate(String name) {
        return DateHelper.read(json.optString(name));
    }

    @Override
    public ModelDataReader getReaderFor(String name) {
        return json.has(name) ? new JsonDataReader(json.optJSONObject(name)) : new JsonDataReader(new JSONObject());
    }
}

