package ru.yandex.webmaster3.core.semantic.review_business.model.utilities.json;

import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.webmaster3.core.semantic.review_business.model.utilities.ModelDataWriter;
import ru.yandex.webmaster3.core.semantic.review_business.model.utilities.ModelWriteException;
import ru.yandex.webmaster3.core.semantic.review_business.util.DateHelper;

import java.util.Date;

/**
 * User: Evgeny Zhoga <ezhoga@yandex-team.ru>
 * Date: 18.11.13
 */
public class JsonDataWriter implements ModelDataWriter<JSONObject> {
    private final JSONObject json;

    public JsonDataWriter() {
        this.json = new JSONObject();
    }

    @Override
    public void put(String name, String value) throws ModelWriteException {
        try {
            json.putOpt(name, value);
        } catch (JSONException e) {
            throw new ModelWriteException();
        }
    }

    @Override
    public void put(String name, Integer value) throws ModelWriteException {
        try {
            json.putOpt(name, value);
        } catch (JSONException e) {
            throw new ModelWriteException();
        }
    }

    @Override
    public void put(String name, Long value) throws ModelWriteException {
        try {
            json.putOpt(name, value);
        } catch (JSONException e) {
            throw new ModelWriteException();
        }
    }

    @Override
    public void put(String name, Float value) throws ModelWriteException {
        try {
            json.putOpt(name, value);
        } catch (JSONException e) {
            throw new ModelWriteException();
        }
    }

    @Override
    public void put(String name, Double value) throws ModelWriteException {
        try {
            json.putOpt(name, value);
        } catch (JSONException e) {
            throw new ModelWriteException();
        }
    }

    @Override
    public void put(String name, Boolean value) throws ModelWriteException {
        try {
            json.putOpt(name, value);
        } catch (JSONException e) {
            throw new ModelWriteException();
        }
    }

    @Override
    public void put(String name, Date value) throws ModelWriteException {
        try {
            json.putOpt(name, DateHelper.write(value));
        } catch (JSONException e) {
            throw new ModelWriteException();
        }
    }

    @Override
    public void put(String name, Object value) throws ModelWriteException {
        try {
            json.putOpt(name, value);
        } catch (JSONException e) {
            throw new ModelWriteException();
        }
    }

    @Override
    public JsonDataWriter getChildWriter(String name) throws ModelWriteException {
        JsonDataWriter childWriter = new JsonDataWriter();
        try {
            json.put(name, childWriter.get());
        } catch (JSONException e) {
            throw new ModelWriteException(e);
        }
        return childWriter;
    }

    @Override
    public JSONObject get() {
        return json;
    }
}
