package ru.yandex.webmaster3.core.semantic.schema_org_information_extractor;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import ru.yandex.common.util.XmlUtils;
import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.functional.Filter;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 3/26/12
 * Time: 11:09 AM
 */
public class RDFParser {

    private final String content;

    public RDFParser(final String content) {
        this.content = content;
    }

    public List<RDFsEntity> getEntities() {
        Document doc;
        try {
            doc = XmlUtils.parseSource(content);
        } catch (SAXException e) {
            return Collections.EMPTY_LIST;
        } catch (IOException e) {
            return Collections.EMPTY_LIST;
        }
        List<Element> elements = XmlUtils.allInSubtree(doc.getDocumentElement());
        final List<RDFsEntity> result = new LinkedList<RDFsEntity>();
        final Iterable<Element> classes = Cu.filter(elements, new Filter<Element>() {
            @Override
            public boolean fits(final Element element) {
                return element.getNodeName().equalsIgnoreCase("Class");
            }
        });

        return result;
    }


}
