package ru.yandex.webmaster3.core.semantic.schema_org_information_extractor;

import ru.yandex.common.util.collections.MultiMap;

import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 3/26/12
 * Time: 11:28 AM
 */
public class RDFsEntity {

    public final String typeOf;
    public final String about;
    private final MultiMap<String, String> properties;

    public RDFsEntity(final String typeOf, final String about) {
        this.typeOf = typeOf;
        this.about = about;
        this.properties = new MultiMap<String, String>();
    }

    public void addProperty(final String property, final String value) {
        this.properties.append(property, value);
    }

    public String getFirst(final String property) {
        return this.properties.head(property);
    }

    public List<String> getValue(final String property) {
        return (this.properties.containsKey(property)) ? (this.properties.get(property)) : Collections.EMPTY_LIST;
    }

    public MultiMap<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        final StringBuilder builder = new StringBuilder();
        builder.append("About: ").append(about).append(" typeOf: ").append(typeOf).append("\n");
        for (final String key : properties.keySet()) {
            builder.append(key).append(" :");
            for (final String val : properties.get(key)) {
                builder.append(" \"").append(val).append("\"");
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}
