package ru.yandex.webmaster3.core.semantic.schema_org_information_extractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import com.google.common.base.Preconditions;

import ru.yandex.common.util.xml.Xmler;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 4/2/12
 * Time: 12:49 AM
 */
public class SchemaClass {

    public final String name;
    public String label;
    public final List<SchemaClass> subClassOf = new ArrayList<>();
    public final HashMap<String, SchemaField> fields = new HashMap<>();

    public SchemaClass(final String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addSubClassOf(final SchemaClass schClass) {
        Preconditions.checkNotNull(schClass, "attempt to add null subclass to class " + name);
        subClassOf.add(schClass);
    }

    public void addField(final SchemaField field) {
         fields.put(field.name, field);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("name: ").append(name).append("\nsubclass of:");
        for (final SchemaClass sc : subClassOf) {
            sb.append(" ").append(sc.name);
        }
        sb.append("\nfields:");
        for (final SchemaField field : fields.values()) {
            sb.append(" ").append(field.name);
        }
        return sb.toString();
    }

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        for (final SchemaClass cls : subClassOf) {
            tags.add(tag("subclass-of", cls.name));
        }
        for (final SchemaField field : fields.values()) {
            tags.add(field.toXml());
        }
        return tag("class", attribute("name", name), tags);
    }

}
