package ru.yandex.webmaster3.core.semantic.schema_org_information_extractor;

import ru.yandex.common.util.xml.Xmler;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 4/2/12
 * Time: 12:51 AM
 */
public class SchemaField {

    public final String name;
    public final List<SchemaClass> domains = new LinkedList<SchemaClass>();
    public final List<String> ranges = new LinkedList<String>();

    public SchemaField(final String name) {
        this.name = name;
    }

    public void addDomain(final SchemaClass domain) {
        domains.add(domain);
    }

    public void addRange(final String range) {
        ranges.add(range);
    }

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        for (final String range : ranges) {
            tags.add(tag("range", range));
        }
        return tag("field", attribute("name", name), tags);
    }
}
