package ru.yandex.webmaster3.core.semantic.schema_org_information_extractor;

import ru.yandex.common.util.IOUtils;
import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.functional.Filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.header;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 3/26/12
 * Time: 12:32 PM
 */
public class UtilityTest {

    public static void main(String[] args) throws IOException {
        HashMap<String, SchemaClass> classes = getSchemaClassMap();

        PrintWriter outFile = new PrintWriter("classes.xml");
        StringBuilder sb = new StringBuilder();
        header().toXml(sb);
        sb.append("\n<classes>\n");
        for (final SchemaClass cls : classes.values()) {
            cls.toXml().toXml(sb);
        }
        sb.append("</classes>");
        outFile.print(sb.toString());
        outFile.close();
    }

    public static HashMap<String, SchemaClass> getSchemaClassMap() throws IOException {
        final URL url = new URL("http://www.schema.org/docs/schema_org_rdfa.html");
        final String content = IOUtils.readInputStream(url.openStream());
        Parser parser = new Parser(content);
        List<RDFsEntity> entities = parser.getEntities();
        Filter<RDFsEntity> isClass = new Filter<RDFsEntity>() {
            @Override
            public boolean fits(final RDFsEntity rdFsEntity) {
                return "rdfs:Class".equals(rdFsEntity.typeOf);
            }
        };
        Pair<List<RDFsEntity>, List<RDFsEntity>> all = Cu.split(entities, isClass);
        HashMap<String, SchemaClass> classes = new HashMap<String, SchemaClass>();
        for (final RDFsEntity entity : all.first) {
            SchemaClass newClass = classes.get(entity.about);
            if (newClass == null) {
                newClass = new SchemaClass(entity.about);
            }
            newClass.setLabel(entity.getFirst("rdfs:label"));
            if (entity.getValue("rdfs:subClassOf") != null) {
                for (final String sclass : entity.getValue("rdfs:subClassOf")) {
                    SchemaClass sc = classes.get(sclass);
                    if (sc == null) {
                        sc = new SchemaClass(sclass);
                        classes.put(sclass, sc);
                    }
                    newClass.addSubClassOf(sc);
                }
            }
            classes.put(newClass.name, newClass);
        }

        for (final RDFsEntity entity : all.second) {
            SchemaField field = new SchemaField(entity.getFirst("rdfs:label"));
            for (final String domain : entity.getValue("http://schema.org/domain")) {
                field.addDomain(classes.get(domain));
                classes.get(domain).addField(field);
            }
            for (final String range : entity.getValue("http://schema.org/range")) {
                field.addRange(range);
            }
        }

        LinkedList<String> qu = new LinkedList<String>();
        HashMap<String, Integer> chc = new HashMap<String, Integer>();
        HashMap<String, List<String>> chlidren = new HashMap<String, List<String>>();
        for (final String key : classes.keySet()) {
            SchemaClass val = classes.get(key);
            chc.put(key, val.subClassOf.size());
            if (val.subClassOf.size() == 0) {
                qu.add(key);
            }
            for (final SchemaClass parent : val.subClassOf) {
                List<String> childList = chlidren.get(parent.name);
                if (childList == null) {
                    childList = new LinkedList<String>();
                    chlidren.put(parent.name, childList);
                }
                childList.add(key);
            }
        }

        while (!qu.isEmpty()) {
            final String key = qu.poll();
            SchemaClass cls = classes.get(key);
            for (final SchemaClass sup : cls.subClassOf) {
                cls.fields.putAll(sup.fields);
            }
            if (chlidren.containsKey(key)) {
                for (final String child : chlidren.get(key)) {
                    Integer pcnt = chc.get(child);
                    pcnt--;
                    chc.put(child, pcnt);
                    if (pcnt == 0) {
                        qu.add(child);
                    }
                }
            }
        }
        return classes;
    }
}
