package ru.yandex.webmaster3.core.semantic.semantic_document_parser.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker.LanguageContext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 14.09.12
 * Time: 18:19
 */
public class ExceptionSerializerFactory {

    private static Map<LanguageContext, TankerVerifierExceptionSerializer> serializerMap =
            new ConcurrentHashMap<LanguageContext, TankerVerifierExceptionSerializer>();

    public TankerVerifierExceptionSerializer createSerializer(final LanguageContext context) {
        if (serializerMap.containsKey(context)) {
            return serializerMap.get(context);
        } else {
            final TankerVerifierExceptionSerializer serializer = new TankerVerifierExceptionSerializer(context);
            serializerMap.put(context, serializer);
            return serializer;
        }
    }
}
