package ru.yandex.webmaster3.core.semantic.semantic_document_parser.location;

/**
 * Created by aleksart on 10.07.15.
 */
public class EntityLocation implements Comparable {

    private int line;
    private int column;

    public  static final EntityLocation DEFAULT_LOCATION = new EntityLocation(-1,-1);

    public EntityLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public EntityLocation(String doubleDotSeparated){
        String[] coordinates = doubleDotSeparated.split(":");
        if(coordinates.length == 2){
            this.line = new Integer(coordinates[0]);
            this.column = new Integer(coordinates[1]);
        }
    }

    public int getColumn() {
        return column;
    }

    public int getLine() {
        return line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EntityLocation that = (EntityLocation) o;

        if (line != that.line) return false;
        return column == that.column;

    }

    @Override
    public int hashCode() {
        int result = line;
        result = 31 * result + column;
        return result;
    }

    @Override
    public int compareTo(Object o) {

        if(o instanceof EntityLocation){
            if(((EntityLocation) o).getLine() > this.line){
                return -1;
            }
            else if (((EntityLocation) o).getLine() == this.getLine()){
                return this.column - ((EntityLocation) o).getColumn();
            }
            else{
                return 1;
            }
        }
        else {
            return 0;
        }
    }

    @Override
    public String toString() {
        return line+":"+column;
    }
}
