package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.classificator;

import ru.yandex.common.util.collections.Cf;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 8/8/11
 * Time: 3:48 PM
 * To change this template use File | Settings | File Templates.
 */
public class ItemTypeClassificator {

    public static final List<String> supportedClasses = Collections.unmodifiableList(
            Cf.list("Organization", "Place", "ImageObject", "VideoObject", "ScholarlyArticle", "Recipe", "Person",
                    "NutritionInformation", "PostalAddress"));

    public static boolean isSupported(final String classname) {
        return supportedClasses.contains(classname);
    }

    private static final Map<String, String> parent = new HashMap<String, String>();

    static {
        final String[][] parentsMapInit = {
                // Typo fix
                {"Organisation", "Organization"},
                // Organization
                {"Corporation", "Organization"}, {"EducationalOrganization", "Organization"},
                {"GovernmentOrganization", "Organization"}, {"LocalBusiness", "Organization"}, {"NGO", "Organization"},
                {"PerformingGroup", "Organization"}, {"SportsTeam", "Organization"},
                {"CollegeOrUniversity", "EducationalOrganization"}, {"ElementarySchool", "EducationalOrganization"},
                {"HighSchool", "EducationalOrganization"}, {"MiddleSchool", "EducationalOrganization"},
                {"Preschool", "EducationalOrganization"}, {"School", "EducationalOrganization"},
                {"AnimalShelter", "LocalBusiness"}, {"AutomotiveBusiness", "LocalBusiness"},
                {"ChildCare", "LocalBusiness"}, {"DryCleaningOrLaundry", "LocalBusiness"},
                {"EmergencyService", "LocalBusiness"}, {"EmploymentAgency", "LocalBusiness"},
                {"EntertainmentBusiness", "LocalBusiness"}, {"FinancialService", "LocalBusiness"},
                {"FoodEstablishment", "LocalBusiness"}, {"GovernmentOffice", "LocalBusiness"},
                {"HealthAndBeautyBusiness", "LocalBusiness"}, {"HomeAndConstructionBusiness", "LocalBusiness"},
                {"InternetCafe", "LocalBusiness"}, {"Library", "LocalBusiness"}, {"LodgingBusiness", "LocalBusiness"},
                {"MedicalOrganization", "LocalBusiness"}, {"ProfessionalService", "LocalBusiness"},
                {"RadioStation", "LocalBusiness"}, {"RealEstateAgent", "LocalBusiness"},
                {"RecyclingCenter", "LocalBusiness"}, {"SelfStorage", "LocalBusiness"},
                {"ShoppingCenter", "LocalBusiness"}, {"SportsActivityLocation", "LocalBusiness"},
                {"Store", "LocalBusiness"}, {"TelevisionStation", "LocalBusiness"},
                {"TouristInformationCenter", "LocalBusiness"}, {"TravelAgency", "LocalBusiness"},
                {"AutoBodyShop", "AutomotiveBusiness"}, {"AutoDealer", "AutomotiveBusiness"},
                {"AutoPartsStore", "AutomotiveBusiness"}, {"AutoRental", "AutomotiveBusiness"},
                {"AutoRepair", "AutomotiveBusiness"}, {"AutoWash", "AutomotiveBusiness"},
                {"GasStation", "AutomotiveBusiness"}, {"MotorcycleDealer", "AutomotiveBusiness"},
                {"MotorcycleRepair", "AutomotiveBusiness"}, {"FireStation", "EmergencyService"},
                {"Hospital", "EmergencyService"}, {"PoliceStation", "EmergencyService"},
                {"AdultEntertainment", "EntertainmentBusiness"}, {"AmusementPark", "EntertainmentBusiness"},
                {"ArtGallery", "EntertainmentBusiness"}, {"Casino", "EntertainmentBusiness"},
                {"ComedyClub", "EntertainmentBusiness"}, {"MovieTheater", "EntertainmentBusiness"},
                {"NightClub", "EntertainmentBusiness"}, {"AccountingService", "FinancialService"},
                {"AutomatedTeller", "FinancialService"}, {"BankOrCreditUnion", "FinancialService"},
                {"InsuranceAgency", "FinancialService"}, {"Bakery", "FoodEstablishment"},
                {"BarOrPub", "FoodEstablishment"}, {"Brewery", "FoodEstablishment"},
                {"CafeOrCoffeeShop", "FoodEstablishment"}, {"FastFoodRestaurant", "FoodEstablishment"},
                {"IceCreamShop", "FoodEstablishment"}, {"Restaurant", "FoodEstablishment"},
                {"Winery", "FoodEstablishment"}, {"PostOffice", "GovernmentOffice"},
                {"BeautySalon", "HealthAndBeautyBusiness"}, {"DaySpa", "HealthAndBeautyBusiness"},
                {"HairSalon", "HealthAndBeautyBusiness"}, {"HealthClub", "HealthAndBeautyBusiness"},
                {"NailSalon", "HealthAndBeautyBusiness"}, {"TattooParlor", "HealthAndBeautyBusiness"},
                {"Electrician", "HomeAndConstructionBusiness"}, {"GeneralContractor", "HomeAndConstructionBusiness"},
                {"HVACBusiness", "HomeAndConstructionBusiness"}, {"HousePainter", "HomeAndConstructionBusiness"},
                {"Locksmith", "HomeAndConstructionBusiness"}, {"MovingCompany", "HomeAndConstructionBusiness"},
                {"Plumber", "HomeAndConstructionBusiness"}, {"RoofingContractor", "HomeAndConstructionBusiness"},
                {"BedAndBreakfast", "LodgingBusiness"}, {"Hostel", "LodgingBusiness"}, {"Hotel", "LodgingBusiness"},
                {"Motel", "LodgingBusiness"}, {"Dentist", "MedicalOrganization"}, {"Hospital", "MedicalOrganization"},
                {"MedicalClinic", "MedicalOrganization"}, {"Optician", "MedicalOrganization"},
                {"Pharmacy", "MedicalOrganization"}, {"Physician", "MedicalOrganization"},
                {"VeterinaryCare", "MedicalOrganization"}, {"AccountingService", "ProfessionalService"},
                {"Attorney", "ProfessionalService"}, {"Dentist", "ProfessionalService"},
                {"Electrician", "ProfessionalService"}, {"GeneralContractor", "ProfessionalService"},
                {"HousePainter", "ProfessionalService"}, {"Locksmith", "ProfessionalService"},
                {"Notary", "ProfessionalService"}, {"Plumber", "ProfessionalService"},
                {"RoofingContractor", "ProfessionalService"}, {"BowlingAlley", "SportsActivityLocation"},
                {"ExerciseGym", "SportsActivityLocation"}, {"GolfCourse", "SportsActivityLocation"},
                {"HealthClub", "SportsActivityLocation"}, {"PublicSwimmingPool", "SportsActivityLocation"},
                {"SkiResort", "SportsActivityLocation"}, {"SportsClub", "SportsActivityLocation"},
                {"StadiumOrArena", "SportsActivityLocation"}, {"TennisComplex", "SportsActivityLocation"},
                {"AutoPartsStore", "Store"}, {"BikeStore", "Store"}, {"BookStore", "Store"}, {"ClothingStore", "Store"},
                {"ComputerStore", "Store"}, {"ConvenienceStore", "Store"}, {"DepartmentStore", "Store"},
                {"ElectronicsStore", "Store"}, {"Florist", "Store"}, {"FurnitureStore", "Store"},
                {"GardenStore", "Store"}, {"GroceryStore", "Store"}, {"HardwareStore", "Store"}, {"HobbyShop", "Store"},
                {"HomeGoodsStore", "Store"}, {"JewelryStore", "Store"}, {"LiquorStore", "Store"},
                {"MensClothingStore", "Store"}, {"MobilePhoneStore", "Store"}, {"MovieRentalStore", "Store"},
                {"MusicStore", "Store"}, {"OfficeEquipmentStore", "Store"}, {"OutletStore", "Store"},
                {"PawnShop", "Store"}, {"PetStore", "Store"}, {"ShoeStore", "Store"}, {"SportingGoodsStore", "Store"},
                {"TireShop", "Store"}, {"ToyStore", "Store"}, {"WholesaleStore", "Store"},
                {"DanceGroup", "PerformingGroup"},
                {"TheaterGroup", "PerformingGroup"},
                //Place
                {"AdministrativeArea", "Place"}, {"CivicStructure", "Place"}, {"Landform", "Place"},
                {"LandmarksOrHistoricalBuildings", "Place"}, {"LocalBusiness", "Place"}, {"Residence", "Place"},
                {"TouristAttraction", "Place"}, {"City", "AdministrativeArea"}, {"Country", "AdministrativeArea"},
                {"State", "AdministrativeArea"}, {"Airport", "CivicStructure"}, {"Aquarium", "CivicStructure"},
                {"Beach", "CivicStructure"}, {"BusStation", "CivicStructure"}, {"BusStop", "CivicStructure"},
                {"Campground", "CivicStructure"}, {"Cemetery", "CivicStructure"}, {"Crematorium", "CivicStructure"},
                {"EventVenue", "CivicStructure"}, {"FireStation", "CivicStructure"},
                {"GovernmentBuilding", "CivicStructure"}, {"Hospital", "CivicStructure"},
                {"MovieTheater", "CivicStructure"}, {"Museum", "CivicStructure"}, {"MusicVenue", "CivicStructure"},
                {"Park", "CivicStructure"}, {"ParkingFacility", "CivicStructure"},
                {"PerformingArtsTheater", "CivicStructure"}, {"PlaceOfWorship", "CivicStructure"},
                {"Playground", "CivicStructure"}, {"PoliceStation", "CivicStructure"}, {"RVPark", "CivicStructure"},
                {"StadiumOrArena", "CivicStructure"}, {"SubwayStation", "CivicStructure"},
                {"TaxiStand", "CivicStructure"}, {"TrainStation", "CivicStructure"}, {"Zoo", "CivicStructure"},
                {"CityHall", "GovernmentBuilding"}, {"Courthouse", "GovernmentBuilding"},
                {"DefenceEstablishment", "GovernmentBuilding"}, {"Embassy", "GovernmentBuilding"},
                {"LegislativeBuilding", "GovernmentBuilding"}, {"BuddhistTemple", "PlaceOfWorship"},
                {"CatholicChurch", "PlaceOfWorship"}, {"Church", "PlaceOfWorship"}, {"HinduTemple", "PlaceOfWorship"},
                {"Mosque", "PlaceOfWorship"}, {"Synagogue", "PlaceOfWorship"}, {"BodyOfWater", "Landform"},
                {"Continent", "Landform"}, {"Mountain", "Landform"}, {"Volcano", "Landform"}, {"Canal", "BodyOfWater"},
                {"LakeBodyOfWater", "BodyOfWater"}, {"OceanBodyOfWater", "BodyOfWater"}, {"Pond", "BodyOfWater"},
                {"Reservoir", "BodyOfWater"}, {"RiverBodyOfWater", "BodyOfWater"}, {"SeaBodyOfWater", "BodyOfWater"},
                {"Waterfall", "BodyOfWater"}, {"AnimalShelter", "LocalBusiness"},
                {"AutomotiveBusiness", "LocalBusiness"}, {"ChildCare", "LocalBusiness"},
                {"DryCleaningOrLaundry", "LocalBusiness"}, {"EmergencyService", "LocalBusiness"},
                {"EmploymentAgency", "LocalBusiness"}, {"EntertainmentBusiness", "LocalBusiness"},
                {"FinancialService", "LocalBusiness"}, {"FoodEstablishment", "LocalBusiness"},
                {"GovernmentOffice", "LocalBusiness"}, {"HealthAndBeautyBusiness", "LocalBusiness"},
                {"HomeAndConstructionBusiness", "LocalBusiness"}, {"InternetCafe", "LocalBusiness"},
                {"Library", "LocalBusiness"}, {"LodgingBusiness", "LocalBusiness"},
                {"MedicalOrganization", "LocalBusiness"}, {"ProfessionalService", "LocalBusiness"},
                {"RadioStation", "LocalBusiness"}, {"RealEstateAgent", "LocalBusiness"},
                {"RecyclingCenter", "LocalBusiness"}, {"SelfStorage", "LocalBusiness"},
                {"ShoppingCenter", "LocalBusiness"}, {"SportsActivityLocation", "LocalBusiness"},
                {"Store", "LocalBusiness"}, {"TelevisionStation", "LocalBusiness"},
                {"TouristInformationCenter", "LocalBusiness"}, {"TravelAgency", "LocalBusiness"},
                {"AutoBodyShop", "AutomotiveBusiness"}, {"AutoDealer", "AutomotiveBusiness"},
                {"AutoPartsStore", "AutomotiveBusiness"}, {"AutoRental", "AutomotiveBusiness"},
                {"AutoRepair", "AutomotiveBusiness"}, {"AutoWash", "AutomotiveBusiness"},
                {"GasStation", "AutomotiveBusiness"}, {"MotorcycleDealer", "AutomotiveBusiness"},
                {"MotorcycleRepair", "AutomotiveBusiness"}, {"FireStation", "EmergencyService"},
                {"Hospital", "EmergencyService"}, {"PoliceStation", "EmergencyService"},
                {"AdultEntertainment", "EntertainmentBusiness"}, {"AmusementPark", "EntertainmentBusiness"},
                {"ArtGallery", "EntertainmentBusiness"}, {"Casino", "EntertainmentBusiness"},
                {"ComedyClub", "EntertainmentBusiness"}, {"MovieTheater", "EntertainmentBusiness"},
                {"NightClub", "EntertainmentBusiness"}, {"AccountingService", "FinancialService"},
                {"AutomatedTeller", "FinancialService"}, {"BankOrCreditUnion", "FinancialService"},
                {"InsuranceAgency", "FinancialService"}, {"Bakery", "FoodEstablishment"},
                {"BarOrPub", "FoodEstablishment"}, {"Brewery", "FoodEstablishment"},
                {"CafeOrCoffeeShop", "FoodEstablishment"}, {"FastFoodRestaurant", "FoodEstablishment"},
                {"IceCreamShop", "FoodEstablishment"}, {"Restaurant", "FoodEstablishment"},
                {"Winery", "FoodEstablishment"}, {"PostOffice", "GovernmentOffice"},
                {"BeautySalon", "HealthAndBeautyBusiness"}, {"DaySpa", "HealthAndBeautyBusiness"},
                {"HairSalon", "HealthAndBeautyBusiness"}, {"HealthClub", "HealthAndBeautyBusiness"},
                {"NailSalon", "HealthAndBeautyBusiness"}, {"TattooParlor", "HealthAndBeautyBusiness"},
                {"Electrician", "HomeAndConstructionBusiness"}, {"GeneralContractor", "HomeAndConstructionBusiness"},
                {"HVACBusiness", "HomeAndConstructionBusiness"}, {"HousePainter", "HomeAndConstructionBusiness"},
                {"Locksmith", "HomeAndConstructionBusiness"}, {"MovingCompany", "HomeAndConstructionBusiness"},
                {"Plumber", "HomeAndConstructionBusiness"}, {"RoofingContractor", "HomeAndConstructionBusiness"},
                {"BedAndBreakfast", "LodgingBusiness"}, {"Hostel", "LodgingBusiness"}, {"Hotel", "LodgingBusiness"},
                {"Motel", "LodgingBusiness"}, {"Dentist", "MedicalOrganization"}, {"Hospital", "MedicalOrganization"},
                {"MedicalClinic", "MedicalOrganization"}, {"Optician", "MedicalOrganization"},
                {"Pharmacy", "MedicalOrganization"}, {"Physician", "MedicalOrganization"},
                {"VeterinaryCare", "MedicalOrganization"}, {"AccountingService", "ProfessionalService"},
                {"Attorney", "ProfessionalService"}, {"Dentist", "ProfessionalService"},
                {"Electrician", "ProfessionalService"}, {"GeneralContractor", "ProfessionalService"},
                {"HousePainter", "ProfessionalService"}, {"Locksmith", "ProfessionalService"},
                {"Notary", "ProfessionalService"}, {"Plumber", "ProfessionalService"},
                {"RoofingContractor", "ProfessionalService"}, {"BowlingAlley", "SportsActivityLocation"},
                {"ExerciseGym", "SportsActivityLocation"}, {"GolfCourse", "SportsActivityLocation"},
                {"HealthClub", "SportsActivityLocation"}, {"PublicSwimmingPool", "SportsActivityLocation"},
                {"SkiResort", "SportsActivityLocation"}, {"SportsClub", "SportsActivityLocation"},
                {"StadiumOrArena", "SportsActivityLocation"}, {"TennisComplex", "SportsActivityLocation"},
                {"AutoPartsStore", "Store"}, {"BikeStore", "Store"}, {"BookStore", "Store"}, {"ClothingStore", "Store"},
                {"ComputerStore", "Store"}, {"ConvenienceStore", "Store"}, {"DepartmentStore", "Store"},
                {"ElectronicsStore", "Store"}, {"Florist", "Store"}, {"FurnitureStore", "Store"},
                {"GardenStore", "Store"}, {"GroceryStore", "Store"}, {"HardwareStore", "Store"}, {"HobbyShop", "Store"},
                {"HomeGoodsStore", "Store"}, {"JewelryStore", "Store"}, {"LiquorStore", "Store"},
                {"MensClothingStore", "Store"}, {"MobilePhoneStore", "Store"}, {"MovieRentalStore", "Store"},
                {"MusicStore", "Store"}, {"OfficeEquipmentStore", "Store"}, {"OutletStore", "Store"},
                {"PawnShop", "Store"}, {"PetStore", "Store"}, {"ShoeStore", "Store"}, {"SportingGoodsStore", "Store"},
                {"TireShop", "Store"}, {"ToyStore", "Store"}, {"WholesaleStore", "Store"},
                {"ApartmentComplex", "Residence"}, {"GatedResidenceCommunity", "Residence"},
                {"SingleFamilyResidence", "Residence"}};
        for (final String[] row : parentsMapInit) {
            parent.put(row[0], row[1]);
        }
    }

    static private final HashMap<String, String> catByType = new HashMap<String, String>();

    static {
        final String[][] catByTypeRaw =
                {{"CollegeOrUniversity", "184106236"}, {"ElementarySchool", "184106240"}, {"HighSchool", "184106140"},
                        {"MiddleSchool", "184106240"}, {"Preschool", "184107206"}, {"School", "184106240"},
                        {"AnimalShelter", "184107220"}, {"AutoBodyShop", "184105320"}, {"AutoDealer", "184105322"},
                        {"AutoPartsStore", "184105320"}, {"AutoRental", "184108161"}, {"AutoRepair", "184105246"},
                        {"AutoWash", "184105244"}, {"GasStation", "184105274"}, {"MotorcycleDealer", "184107337"},
                        {"MotorcycleRepair", "184107337"}, {"DryCleaningOrLaundry", "184108251"},
                        {"EmergencyService", "184108289"}, {"FireStation", "184105376"}, {"Hospital", "184105956"},
                        {"PoliceStation", "184105692"}, {"EmploymentAgency", "184105460"},
                        {"AmusementPark", "184106346"}, {"ArtGallery", "184105892"}, {"Casino", "184106334"},
                        {"MovieTheater", "184105868"}, {"NightClub", "184106368"}, {"AccountingService", "184105392"},
                        {"AutomatedTeller", "184105402"}, {"BankOrCreditUnion", "184105398"},
                        {"InsuranceAgency", "184105534"}, {"Bakery", "184106796"}, {"BarOrPub", "184106384"},
                        {"Brewery", "184106776"}, {"CafeOrCoffeeShop", "184106390"},
                        {"FastFoodRestaurant", "184106386"}, {"Restaurant", "184106394"}, {"Winery", "184107897"},
                        {"GovernmentOffice", "184105716"}, {"PostOffice", "184108341"}, {"BeautySalon", "184105814"},
                        {"DaySpa", "184105818"}, {"HairSalon", "184105812"}, {"HealthClub", "184106112"},
                        {"NailSalon", "184105814"}, {"TattooParlor", "184105820"}, {"Electrician", "184107655"},
                        {"GeneralContractor", "184107633"}, {"MovingCompany", "184108197"}, {"Plumber", "184107545"},
                        {"RoofingContractor", "184107607"}, {"InternetCafe", "184105740"}, {"Library", "184105838"},
                        {"Hostel", "184106316"}, {"Hotel", "184106414"}, {"Motel", "184106414"},
                        {"Dentist", "184106132"}, {"Hospital", "184105956"}, {"MedicalClinic", "184106104"},
                        {"Optician", "184106052"}, {"Pharmacy", "184105932"}, {"Physician", "585423074"},
                        {"VeterinaryCare", "184107216"}, {"AccountingService", "184105392"}, {"Attorney", "184105616"},
                        {"Dentist", "184106132"}, {"Electrician", "184107655"}, {"GeneralContractor", "184107633"},
                        {"Notary", "184105624"}, {"Plumber", "184107545"}, {"RoofingContractor", "184107607"},
                        {"RadioStation", "184107397"}, {"RealEstateAgent", "184107503"},
                        {"RecyclingCenter", "184106748"}, {"SelfStorage", "184105438"}, {"ShoppingCenter", "184108083"},
                        {"BowlingAlley", "184106360"}, {"ExerciseGym", "184107297"}, {"HealthClub", "184106112"},
                        {"PublicSwimmingPool", "184107275"}, {"SkiResort", "184107293"}, {"SportsClub", "184107297"},
                        {"StadiumOrArena", "184107315"}, {"TennisComplex", "184107319"},
                        {"AutoPartsStore", "184105320"}, {"BikeStore", "184107325"}, {"BookStore", "184105886"},
                        {"ClothingStore", "184107943"}, {"ComputerStore", "184105760"},
                        {"DepartmentStore", "184108085"}, {"ElectronicsStore", "184107835"}, {"Florist", "184108325"},
                        {"FurnitureStore", "184107871"}, {"GardenStore", "184108051"}, {"GroceryStore", "184108031"},
                        {"HomeGoodsStore", "184108097"}, {"JewelryStore", "184105828"}, {"LiquorStore", "184107899"},
                        {"MensClothingStore", "184107943"}, {"MobilePhoneStore", "184107789"},
                        {"MovieRentalStore", "184105858"}, {"MusicStore", "184105910"},
                        {"OfficeEquipmentStore", "184105552"}, {"PawnShop", "184105578"}, {"PetStore", "184107222"},
                        {"ShoeStore", "184107941"}, {"SportingGoodsStore", "184107345"}, {"TireShop", "184105298"},
                        {"ToyStore", "184107250"}, {"WholesaleStore", "184108067"}, {"TelevisionStation", "184107409"},
                        {"TravelAgency", "184106432"}, {"Airport", "184108111"},
                        {"Aquarium", "184106340"}, {"Beach", "184106342"}, {"BusStation", "184108121"},
                        {"Cemetery", "184108357"}, {"Crematorium", "184108359"}, {"FireStation", "184105376"},
                        {"Hospital", "184105956"}, {"MovieTheater", "184105868"}, {"Museum", "184105894"},
                        {"Park", "184106346"}, {"ParkingFacility", "184105270"}, {"PerformingArtsTheater", "184105872"},
                        {"BuddhistTemple", "184106298"}, {"CatholicChurch", "184106298"}, {"Church", "184106298"},
                        {"HinduTemple", "184106298"}, {"Mosque", "184106298"}, {"Synagogue", "184106298"},
                        {"PoliceStation", "184105692"}, {"StadiumOrArena", "184107315"}, {"TaxiStand", "184108171"},
                        {"TrainStation", "184108155"}, {"Zoo", "184106344"}, {"AnimalShelter", "184107220"},
                        {"AutoBodyShop", "184105320"}, {"AutoDealer", "184105322"}, {"AutoPartsStore", "184105320"},
                        {"AutoRental", "184108161"}, {"AutoRepair", "184105246"}, {"AutoWash", "184105244"},
                        {"GasStation", "184105274"}, {"MotorcycleDealer", "184107337"},
                        {"MotorcycleRepair", "184107337"}, {"DryCleaningOrLaundry", "184108251"},
                        {"EmergencyService", "184108289"}, {"FireStation", "184105376"}, {"Hospital", "184105956"},
                        {"PoliceStation", "184105692"}, {"EmploymentAgency", "184105460"},
                        {"AmusementPark", "184106346"}, {"ArtGallery", "184105892"}, {"Casino", "184106334"},
                        {"MovieTheater", "184105868"}, {"NightClub", "184106368"}, {"AccountingService", "184105392"},
                        {"AutomatedTeller", "184105402"}, {"BankOrCreditUnion", "184105398"},
                        {"InsuranceAgency", "184105534"}, {"Bakery", "184106796"}, {"BarOrPub", "184106384"},
                        {"Brewery", "184106776"}, {"CafeOrCoffeeShop", "184106390"},
                        {"FastFoodRestaurant", "184106386"}, {"Restaurant", "184106394"}, {"Winery", "184107897"},
                        {"GovernmentOffice", "184105716"}, {"PostOffice", "184108341"}, {"BeautySalon", "184105814"},
                        {"DaySpa", "184105818"}, {"HairSalon", "184105812"}, {"HealthClub", "184106112"},
                        {"NailSalon", "184105814"}, {"TattooParlor", "184105820"}, {"Electrician", "184107655"},
                        {"GeneralContractor", "184107633"}, {"MovingCompany", "184108197"}, {"Plumber", "184107545"},
                        {"RoofingContractor", "184107607"}, {"InternetCafe", "184105740"}, {"Library", "184105838"},
                        {"BedAndBreakfast", "184106414"}, {"Hostel", "184106316"}, {"Hotel", "184106414"},
                        {"Motel", "184106414"}, {"Dentist", "184106132"}, {"Hospital", "184105956"},
                        {"MedicalClinic", "184106104"}, {"Optician", "184106052"}, {"Pharmacy", "184105932"},
                        {"Physician", "585423074"}, {"VeterinaryCare", "184107216"}, {"AccountingService", "184105392"},
                        {"Attorney", "184105616"}, {"Dentist", "184106132"}, {"Electrician", "184107655"},
                        {"GeneralContractor", "184107633"}, {"Notary", "184105624"}, {"Plumber", "184107545"},
                        {"RoofingContractor", "184107607"}, {"RadioStation", "184107397"},
                        {"RealEstateAgent", "184107503"}, {"RecyclingCenter", "184106748"},
                        {"SelfStorage", "184105438"}, {"ShoppingCenter", "184108083"}, {"BowlingAlley", "184106360"},
                        {"ExerciseGym", "184107297"}, {"HealthClub", "184106112"}, {"PublicSwimmingPool", "184107275"},
                        {"SkiResort", "184107293"}, {"SportsClub", "184107297"}, {"StadiumOrArena", "184107315"},
                        {"TennisComplex", "184107319"}, {"AutoPartsStore", "184105320"}, {"BikeStore", "184107325"},
                        {"BookStore", "184105886"}, {"ClothingStore", "184107943"}, {"ComputerStore", "184105760"},
                        {"DepartmentStore", "184108085"}, {"ElectronicsStore", "184107835"}, {"Florist", "184108325"},
                        {"FurnitureStore", "184107871"}, {"GardenStore", "184108051"}, {"GroceryStore", "184108031"},
                        {"HardwareStore", "184108093"}, {"HomeGoodsStore", "184108097"}, {"JewelryStore", "184105828"},
                        {"LiquorStore", "184107899"}, {"MensClothingStore", "184107943"},
                        {"MobilePhoneStore", "184107789"}, {"MovieRentalStore", "184105858"},
                        {"MusicStore", "184105910"}, {"OfficeEquipmentStore", "184105552"},
                        {"OutletStore", "184107913"}, {"PawnShop", "184105578"}, {"PetStore", "184107222"},
                        {"ShoeStore", "184107941"}, {"SportingGoodsStore", "184107345"}, {"TireShop", "184105298"},
                        {"ToyStore", "184107250"}, {"WholesaleStore", "184108067"}, {"TelevisionStation", "184107409"},
                        {"TravelAgency", "184106432"}};
        for (final String[] row : catByTypeRaw) {
            catByType.put(row[0], row[1]);
        }
    }

    public static String getRoot(final String itemType) {
        if (parent.containsKey(itemType)) {
            return getRoot(parent.get(itemType));
        } else {
            return itemType;
        }
    }

    public static String getCat(final String itemType) {
        return catByType.get(itemType);
    }
}
