package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.collections.Cu;

import java.util.List;
import java.util.Set;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 25.04.13
 * Time: 18:02
 */
public class MutableComplexMicrodataProxy extends ComplexMicrodata {

    final ComplexMicrodata proto;

    @Override
    public Set<String> getPropList() {
        return Cf.set(Cu.join(proto.getPropList(), super.getPropList()));
    }

    @Override
    public List<Microdata> getPropAsList(final String rawKey) {
        return Cu.join(proto.getPropAsList(rawKey), super.getPropAsList(rawKey));
    }

    @Override
    public void addPropValue(final String key, final Microdata value) {
        super.addPropValue(key, value);
    }

    public MutableComplexMicrodataProxy(final ComplexMicrodata microdata) {
        super(microdata.getType());
        proto = microdata;
    }
}
