package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data;

import ru.yandex.common.util.Su;
import ru.yandex.common.util.XmlUtils;
import ru.yandex.common.util.xml.Xmler;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.tag;
import static ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.FrontEnd.cropString;
import static ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.FrontEnd.verifierNode;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/31/11
 * Time: 1:16 AM
 * To change this template use File | Settings | File Templates.
 */
public class TextMicrodata extends Microdata {

    public final String data;
    public final String href;
    public final String html;

    public TextMicrodata(final String data, final String href, final String html) {
        this.html = html;
        this.data = data == null ? null : XmlUtils.unescapeXml(data).trim();
        if (href != null) {
            this.href = XmlUtils.unescapeXml(href).trim();
        } else {
            this.href = null;
        }
    }

    public TextMicrodata(final String data, final String href, final String html, final EntityLocation location) {
        this.html = html;
        this.data = data == null ? null : XmlUtils.unescapeXml(data).trim();
        if (href != null) {
            this.href = XmlUtils.unescapeXml(href).trim();
        } else {
            this.href = null;
        }
        super.location = location;
    }

    public boolean isEmpty() {
        return (Su.isEmpty(data) && Su.isEmpty(href));
    }

    public String toString() {
        if (href != null) {
            return href;
        }
        return data;
    }

    public String getHref(){
        return null == href ? "" : href;
    }

    public String toDataString() {
        if (data == null) {
            return href;
        }
        return data;
    }

    public String toXmlString() {
        final StringBuilder builder = new StringBuilder();
        if (href != null) {
            builder.append("<href>").append(href).append("</href>");
        }
        if (data != null) {
            builder.append("<text>").append(data).append("</text>");
        }
        return builder.toString();
    }

    public Xmler.Tag toXml(final String name) {
        List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        if (href != null) {
            tags.add(tag("href", href));
        }
        if (data != null) {
            tags.add(tag("text", data));
        }
        return tag(name, tags);
    }

    public Xmler.Tag toValidatorXml(final String name) {
        if (href == null || href.trim().isEmpty()) {
            return (verifierNode(name, null, false, tag("v", cropString(data))));
        }
        if (data == null || data.trim().isEmpty()) {
            return (verifierNode(name, null, false, tag("v", href)));
        }
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        tags.add(verifierNode("href", null, false, tag("v", href)));
        tags.add(verifierNode("text", null, false, tag("v", cropString(data))));
        return verifierNode(name, null, false, tags);
    }

}
