package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions;

import ru.yandex.common.util.xml.Xmler;

import static ru.yandex.common.util.xml.Xmler.*;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/9/11
 * Time: 2:05 AM
 */
public abstract class AbstractMicrodataValidatorExceptionsSerializer implements MicrodataValidatorExceptionsSerializer {

    @Override
    public String toString(MicrodataValidatorException ex) {
        return String.format("%s: %s %s %s", ((ex.isCritical) ? getErrorWord() : getWarningWord()), getPrefix(ex),
                ex.message, getPostfix(ex));
    }

    @Override
    public Xmler.Tag toXml(MicrodataValidatorException ex) {
        final StringBuilder message = new StringBuilder();
        message.append((ex.isCritical) ? getErrorWord() : getWarningWord()).append(": ").append(getPrefix(ex)).append(
                " ");
        final String procMessage = ex.message.replaceAll("\\|",getAltWord());
        tag("b", procMessage.isEmpty()?"":procMessage).toXml(message);
        message.append(" ").append(getPostfix(ex));
        return unescapedTag("error", attribute("card_hash", ex.microdata.hashCode()), message.toString());
    }

    private String getPrefix(MicrodataValidatorException ex) {
        if (ex instanceof NoFieldMicrodataValidatorException) {
            return getMessagePrefix((NoFieldMicrodataValidatorException) ex);
        } else if (ex instanceof YandexOrgTelMicrodataValidatorException) {
            return getMessagePrefix((YandexOrgTelMicrodataValidatorException)ex);
        } else if (ex instanceof UnsupportedCountryMicrodataValidatorException) {
            return getMessagePrefix((UnsupportedCountryMicrodataValidatorException)ex);
        } else {
            return getMessagePrefix(ex);
        }
    }


    private String getPostfix(MicrodataValidatorException ex) {
        if (ex instanceof NoFieldMicrodataValidatorException) {
            return getMessagePostfix((NoFieldMicrodataValidatorException) ex);
        } else if (ex instanceof YandexOrgTelMicrodataValidatorException) {
            return getMessagePostfix((YandexOrgTelMicrodataValidatorException) ex);
        } else if (ex instanceof UnsupportedCountryMicrodataValidatorException) {
            return getMessagePostfix((UnsupportedCountryMicrodataValidatorException) ex);
        } else{
            return getMessagePostfix(ex);
        }
    }

    protected abstract String getAltWord();

    protected abstract String getErrorWord();

    protected abstract String getWarningWord();

    protected abstract String getMessagePrefix(final NoFieldMicrodataValidatorException ex);

    protected abstract String getMessagePostfix(final NoFieldMicrodataValidatorException ex);

    protected abstract String getMessagePrefix(final MicrodataValidatorException ex);

    protected abstract String getMessagePostfix(final MicrodataValidatorException ex);

    protected abstract String getMessagePrefix(final YandexOrgTelMicrodataValidatorException ex);

    protected abstract String getMessagePostfix(final YandexOrgTelMicrodataValidatorException ex);

    protected abstract String getMessagePrefix(final UnsupportedCountryMicrodataValidatorException ex);

    protected abstract String getMessagePostfix(final UnsupportedCountryMicrodataValidatorException ex);
}
