package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.validators.MessageStorage;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/14/11
 * Time: 12:12 AM
 */
public class ConfigurableMicrodataValidatorExceptionSerializer extends AbstractMicrodataValidatorExceptionsSerializer {

    private final MessageStorage messageStorage;
    private final String lang;

    private static final String ALT_WORD = "alt_word";
    private static final String ERROR_WORD = "error_word";
    private static final String WARNING_WORD = "warning_word";
    private static final String NO_FIELD = "no_field";
    private static final String YA_ORG_TEL = "ya_org_tel";
    private static final String YA_ORG_COUNTRY = "ya_org_country";
    private static final String GENERAL = "general";

    public ConfigurableMicrodataValidatorExceptionSerializer(final MessageStorage messageStorage, final String lang) {
        this.messageStorage = messageStorage;
        this.lang = lang;
    }

    private String getMsg(final String key) {
        return messageStorage.getMessage(lang, key);
    }

    @Override
    protected String getAltWord() {
        return getMsg(ALT_WORD);
    }

    @Override
    protected String getErrorWord() {
        return getMsg(ERROR_WORD);
    }

    @Override
    protected String getWarningWord() {
        return getMsg(WARNING_WORD);
    }

    @Override
    protected String getMessagePrefix(final NoFieldMicrodataValidatorException ex) {
        return getMsg(NO_FIELD + "_prefix");
    }

    @Override
    protected String getMessagePostfix(final NoFieldMicrodataValidatorException ex) {
        return getMsg(NO_FIELD + "_suffix");
    }

    @Override
    protected String getMessagePrefix(final MicrodataValidatorException ex) {
        return getMsg(GENERAL + "_prefix");
    }

    @Override
    protected String getMessagePostfix(final MicrodataValidatorException ex) {
        return getMsg(GENERAL + "_suffix");
    }

    @Override
    protected String getMessagePrefix(final YandexOrgTelMicrodataValidatorException ex) {
        return getMsg(YA_ORG_TEL + "_prefix");
    }

    @Override
    protected String getMessagePostfix(final YandexOrgTelMicrodataValidatorException ex) {
        return getMsg(YA_ORG_TEL + "_suffix");
    }

    @Override
    protected String getMessagePrefix(final UnsupportedCountryMicrodataValidatorException ex) {
        return getMsg(YA_ORG_COUNTRY + "_prefix");
    }

    @Override
    protected String getMessagePostfix(final UnsupportedCountryMicrodataValidatorException ex) {
        return getMsg(YA_ORG_COUNTRY + "_suffix");
    }
}
