package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.exceptions.VerifierException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/8/11
 * Time: 1:49 AM
 */
public abstract class MicrodataValidatorException extends VerifierException {

    public final boolean isCritical;
    public final String message;
    public final Microdata microdata;
    public EntityLocation location;

    public MicrodataValidatorException(final boolean isCritical, final String message, final Microdata microdata) {
        this.isCritical = isCritical;
        this.message = message;
        this.microdata = microdata;
        if(null!=microdata) {
            this.location = microdata.location;
        }
        else{
            this.location = EntityLocation.DEFAULT_LOCATION;
        }
    }

    public MicrodataValidatorException(boolean isCritical, String message, Microdata microdata, EntityLocation location) {
        this.isCritical = isCritical;
        this.message = message;
        this.microdata = microdata;
        this.location = location;
    }

    @Override
    public boolean getSeverity() {
        return isCritical;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public int getHash() {
        return microdata.number;
    }

    @Override
    public String getLocation(){
        return location.toString();
    }
}
