package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker.LanguageContext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 14.09.12
 * Time: 18:27
 */
public class MicrodataValidatorExceptionsSerializerFactory {

    private static Map<LanguageContext, MicrodataValidatorExceptionsSerializer> serializerMap =
            new ConcurrentHashMap<LanguageContext, MicrodataValidatorExceptionsSerializer>();

    public MicrodataValidatorExceptionsSerializer createSerializer(final LanguageContext context) {
        if (serializerMap.containsKey(context)) {
            return serializerMap.get(context);
        } else {
            final MicrodataValidatorExceptionsSerializer serializer = new TankerMicrodataValidatorExceptionsSerializer(context);
            serializerMap.put(context, serializer);
            return serializer;
        }
    }

}
