package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions;

import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.functional.Function;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.exceptions.PrefixException;

import java.util.Collection;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 05.11.14
 * Time: 14:30
 */
public class PrefixMicrodataExceptionWrapper extends MicrodataValidatorException implements PrefixException {

    final MicrodataValidatorException ex;
    final String prefix;

    public PrefixMicrodataExceptionWrapper(final MicrodataValidatorException ex, final String prefix) {
        super(ex.isCritical,ex.message,ex.microdata);
        this.ex = ex;
        this.prefix = prefix;
    }

    @Override
    public String getKey() {
        return ex.getKey();
    }

    @Override
    public String getPrefix() {
        return prefix;
    }

    public static List<PrefixMicrodataExceptionWrapper> wrapAll(Collection<MicrodataValidatorException> exs, final String prefix) {
        return Cu.map(new Function<MicrodataValidatorException, PrefixMicrodataExceptionWrapper>() {
            @Override
            public PrefixMicrodataExceptionWrapper apply(final MicrodataValidatorException e) {
                return new PrefixMicrodataExceptionWrapper(e,prefix);
            }
        },exs);
    }
}
