package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions;

import ru.yandex.common.util.xml.Xmler;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker.LanguageContext;

import static ru.yandex.common.util.xml.Xmler.*;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 1/27/12
 * Time: 8:52 AM
 */
public class TankerMicrodataValidatorExceptionsSerializer implements MicrodataValidatorExceptionsSerializer {

    private final LanguageContext context;
    private static final String ALT_WORD = "alt_word";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private final String alt_word;
    private final String error;
    private final String warning;

    public TankerMicrodataValidatorExceptionsSerializer(LanguageContext context) {
        this.context = context;
        alt_word = context.getValue(ALT_WORD).getString();
        error = context.getValue(ERROR).getString();
        warning = context.getValue(WARNING).getString();
    }

    @Override
    public String toString(final MicrodataValidatorException ex) {
        return String.format("%s %s %s", ((ex.isCritical) ? getErrorWord() : getWarningWord()),
                getMessage(ex).replaceAll("%s", ex.getMessage()));
    }

    private String getMessage(final MicrodataValidatorException ex) {
        return context.getValue(ex.getKey()).getString();
    }

    private String getWarningWord() {
        return warning;
    }

    private String getErrorWord() {
        return error;
    }

    public String getAltWord() {
        return alt_word;
    }

    @Override
    public Xmler.Tag toXml(final MicrodataValidatorException ex) {
        final StringBuilder message = new StringBuilder();
        message.append((ex.isCritical) ? getErrorWord() : getWarningWord()).append(" ");
        String resultMessage = getMessage(ex);
        final String fullMsg = ex.message;
        final String[] parts = fullMsg.split("\\$\\$");
        {
            final String procMessage = parts[0].replaceAll("\\|", getAltWord());
            final StringBuilder msgTagBuilder = new StringBuilder();
            tag("b", procMessage.isEmpty() ? "" : procMessage).toXml(msgTagBuilder);
            resultMessage = resultMessage.replaceAll("%s", msgTagBuilder.toString());
        }
        for (int i = 0; i < parts.length; i++) {
            final String pattern = "%" + (i + 1);
            final String procMessage = parts[i].replaceAll("\\|", getAltWord());
            final StringBuilder msgTagBuilder = new StringBuilder();
            tag("b", procMessage.isEmpty() ? "" : procMessage).toXml(msgTagBuilder);
            resultMessage = resultMessage.replaceAll(pattern, msgTagBuilder.toString());
        }
        message.append(resultMessage);
        return unescapedTag("error",
                attribute("card_hash", ex.microdata.number).and(attribute("error_code", ex.getKey())),
                message.toString());
    }

}
