package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.transformer;

import ru.yandex.common.util.collections.CollectionFactory;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/15/11
 * Time: 3:10 PM
 * To change this template use File | Settings | File Templates.
 */
public class ByteDocumentContext implements Context<byte[]> {

    final byte[] document;
    final DocumentProperties documentProperties;

    public ByteDocumentContext(final byte[] document, final DocumentProperties documentProperties) {
        this.document = document;
        this.documentProperties = documentProperties;
    }

    @Override
    public TransformationStep getStep() {
        return TransformationStep.DOCUMENT;
    }

    @Override
    public List<byte[]> getInfo() {
        return CollectionFactory.list(document);
    }

    @Override
    public Context<?> nextStep() {
        return new AllByteContext(document, documentProperties);
    }
}
