package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12/3/11
 * Time: 2:28 PM
 */
public class AggregateMicrodataValidator implements MicrodataValidator {

    private final List<MicrodataValidator> validatorList;

    public AggregateMicrodataValidator(List<MicrodataValidator> validatorList){
        this.validatorList = validatorList;
    }

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        final LinkedList<MicrodataValidatorException> exceptions = new LinkedList<MicrodataValidatorException>();
        for (final MicrodataValidator validator : validatorList) {
            exceptions.addAll(validator.validate(microdata));
        }
        return Collections.unmodifiableList(exceptions);
    }
}
