package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.common.util.Su;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.NoFieldMicrodataValidatorException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/21/11
 * Time: 12:39 AM
 */
public class AltFieldListsMicrodataValidator implements MicrodataValidator {

    private List<MustBeFieldsMicrodataValidator> altValidators;
    private boolean isCritical;
    private List<String> fields;

    public AltFieldListsMicrodataValidator(boolean isCritical, final List<String> fields) {
        altValidators = new ArrayList<MustBeFieldsMicrodataValidator>(fields.size());
        for (final String field : fields) {
            altValidators.add(new MustBeFieldsMicrodataValidator(isCritical,field));
        }
        this.isCritical = isCritical;
        this.fields = fields;
    }


    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        for (final MicrodataValidator validator : altValidators) {
            if (validator.validate(microdata).isEmpty())
                return Collections.emptyList();
        }
        return Cf.<MicrodataValidatorException>list(new NoFieldMicrodataValidatorException(isCritical, Su.join(fields," | "),microdata));
    }
}
