package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.NoFieldMicrodataValidatorException;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 13.08.13
 * Time: 12:20
 */
public class AutoYandexSOrgReviewMicrodataValidatorImpl extends YandexSOrgReviewMicrodataValidator {
    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        List<MicrodataValidatorException> result = super.validate(microdata);
        if (microdata instanceof ComplexMicrodata) {
            List<Microdata> itemReviewedes = ((ComplexMicrodata) microdata).getPropAsList("itemReviewed");
            for (Microdata itemReviewed : itemReviewedes) {
                if (itemReviewed != null && itemReviewed instanceof ComplexMicrodata) {
                    if (((ComplexMicrodata) itemReviewed).getFirst("brand") == null) {
                        result.add(new NoFieldMicrodataValidatorException(false, "brand", itemReviewed));
                    }
                    if (((ComplexMicrodata) itemReviewed).getFirst("model") == null) {
                        result.add(new NoFieldMicrodataValidatorException(false, "model", itemReviewed));
                    }
                }
            }
        }
        return result;
    }
}
