package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.NoFieldMicrodataValidatorException;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 09.08.13
 * Time: 16:49
 */
public class BuisnessYandexSOrgReviewMicrodataValidatorImpl extends YandexSOrgReviewMicrodataValidator {

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        List<MicrodataValidatorException> result = super.validate(microdata);
        if (microdata instanceof ComplexMicrodata) {
            Microdata itemReviewed = ((ComplexMicrodata) microdata).getFirst("itemReviewed");
            if (itemReviewed != null && itemReviewed instanceof ComplexMicrodata) {
                if (((ComplexMicrodata) itemReviewed).getFirst("url") == null) {
                    result.add(new NoFieldMicrodataValidatorException(false, "url", itemReviewed));
                }
                if (((ComplexMicrodata) itemReviewed).getFirst("name") == null) {
                    result.add(new NoFieldMicrodataValidatorException(false, "name", itemReviewed));
                }
            }
        }
        return result;
    }
}
